/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.control.http;

import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.control.TpsControlConfig;
import com.alibaba.nacos.core.web.NacosWebBean;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Service
@NacosWebBean
public class HttpTpsPointRegistry
implements ApplicationListener<ContextRefreshedEvent> {
    private volatile AtomicBoolean isInit = new AtomicBoolean(false);

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.isInit.compareAndSet(false, true)) {
            return;
        }
        RequestMappingHandlerMapping requestMapping = (RequestMappingHandlerMapping)event.getApplicationContext().getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map handlerMethods = requestMapping.getHandlerMethods();
        for (HandlerMethod handlerMethod : handlerMethods.values()) {
            Method method = handlerMethod.getMethod();
            if (!method.isAnnotationPresent(TpsControl.class) || !TpsControlConfig.isTpsControlEnabled()) continue;
            TpsControl tpsControl = method.getAnnotation(TpsControl.class);
            String pointName = tpsControl.pointName();
            ControlManagerCenter.getInstance().getTpsControlManager().registerTpsPoint(pointName);
        }
    }
}

