/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.context.remote;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.context.RequestContext;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.utils.WebUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

public class HttpRequestContextFilter
implements Filter {
    private static final String PATTERN_REQUEST_TARGET = "%s %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        RequestContext requestContext = RequestContextHolder.getContext();
        try {
            requestContext.getBasicContext().setRequestProtocol("HTTP");
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            this.setRequestTarget(request, requestContext);
            this.setEncoding(request, requestContext);
            this.setAddressContext(request, requestContext);
            this.setOtherBasicContext(request, requestContext);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            RequestContextHolder.removeContext();
        }
    }

    private void setRequestTarget(HttpServletRequest request, RequestContext requestContext) {
        String uri = request.getRequestURI();
        String method = request.getMethod();
        requestContext.getBasicContext().setRequestTarget(String.format(PATTERN_REQUEST_TARGET, method, uri));
    }

    private void setEncoding(HttpServletRequest request, RequestContext requestContext) {
        String encoding = request.getCharacterEncoding();
        if (StringUtils.isNotBlank((String)encoding)) {
            requestContext.getBasicContext().setEncoding(encoding);
        }
    }

    private void setAddressContext(HttpServletRequest request, RequestContext requestContext) {
        String remoteAddress = request.getRemoteAddr();
        int remotePort = request.getRemotePort();
        String sourceIp = WebUtils.getRemoteIp(request);
        String host = request.getHeader("Host");
        requestContext.getBasicContext().getAddressContext().setRemoteIp(remoteAddress);
        requestContext.getBasicContext().getAddressContext().setRemotePort(remotePort);
        requestContext.getBasicContext().getAddressContext().setSourceIp(sourceIp);
        requestContext.getBasicContext().getAddressContext().setHost(host);
    }

    private void setOtherBasicContext(HttpServletRequest request, RequestContext requestContext) {
        String userAgent = WebUtils.getUserAgent(request);
        requestContext.getBasicContext().setUserAgent(userAgent);
        String app = this.getAppName(request);
        if (StringUtils.isNotBlank((String)app)) {
            requestContext.getBasicContext().setApp(app);
        }
    }

    private String getAppName(HttpServletRequest request) {
        String app = request.getHeader("app");
        if (StringUtils.isBlank((CharSequence)app)) {
            app = request.getHeader("Client-AppName");
        }
        return app;
    }
}

