/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.code.condition;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.ObjectUtils;

public class ParamRequestCondition {
    private final Set<ParamExpression> expressions;

    public ParamRequestCondition(String ... expressions) {
        this.expressions = this.parseExpressions(expressions);
    }

    private Set<ParamExpression> parseExpressions(String ... params) {
        if (ObjectUtils.isEmpty((Object[])params)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ParamExpression> expressions = new LinkedHashSet<ParamExpression>(params.length);
        for (String param : params) {
            expressions.add(new ParamExpression(param));
        }
        return expressions;
    }

    public Set<ParamExpression> getExpressions() {
        return this.expressions;
    }

    public ParamRequestCondition getMatchingCondition(HttpServletRequest request) {
        for (ParamExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return null;
        }
        return this;
    }

    public String toString() {
        return "ParamRequestCondition{expressions=" + String.valueOf(this.expressions) + "}";
    }

    static class ParamExpression {
        private final String name;
        private final String value;
        private final boolean isNegated;

        ParamExpression(String expression) {
            int separator = expression.indexOf(61);
            if (separator == -1) {
                this.isNegated = expression.startsWith("!");
                this.name = this.isNegated ? expression.substring(1) : expression;
                this.value = null;
            } else {
                this.isNegated = separator > 0 && expression.charAt(separator - 1) == '!';
                this.name = this.isNegated ? expression.substring(0, separator - 1) : expression.substring(0, separator);
                this.value = expression.substring(separator + 1);
            }
        }

        public final boolean match(HttpServletRequest request) {
            boolean isMatch = this.value != null ? this.matchValue(request) : this.matchName(request);
            return this.isNegated != isMatch;
        }

        private boolean matchName(HttpServletRequest request) {
            return request.getParameterMap().containsKey(this.name);
        }

        private boolean matchValue(HttpServletRequest request) {
            return ObjectUtils.nullSafeEquals((Object)this.value, (Object)request.getParameter(this.name));
        }

        public String toString() {
            return "ParamExpression{name='" + this.name + "', value='" + this.value + "', isNegated=" + this.isNegated + "}";
        }
    }
}

