/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.code;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.packagescan.DefaultPackageScan;
import com.alibaba.nacos.common.utils.ArrayUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.core.code.RequestMappingInfo;
import com.alibaba.nacos.core.code.condition.ParamRequestCondition;
import com.alibaba.nacos.core.code.condition.PathRequestCondition;
import com.alibaba.nacos.sys.env.EnvUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class ControllerMethodsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerMethodsCache.class);
    private ConcurrentMap<RequestMappingInfo, Method> methods = new ConcurrentHashMap<RequestMappingInfo, Method>();
    private final ConcurrentMap<String, List<RequestMappingInfo>> urlLookup = new ConcurrentHashMap<String, List<RequestMappingInfo>>();
    private final Set<Class> scannedClass = new HashSet<Class>();

    public Method getMethod(HttpServletRequest request) {
        String path = this.getPath(request);
        String httpMethod = request.getMethod();
        String urlKey = httpMethod + "-->" + path.replaceFirst(EnvUtil.getContextPath(), "");
        List requestMappingInfos = (List)this.urlLookup.get(urlKey);
        if (CollectionUtils.isEmpty((Collection)requestMappingInfos)) {
            return null;
        }
        List<RequestMappingInfo> matchedInfo = this.findMatchedInfo(requestMappingInfos, request);
        if (CollectionUtils.isEmpty(matchedInfo)) {
            return null;
        }
        RequestMappingInfo bestMatch = matchedInfo.get(0);
        if (matchedInfo.size() > 1) {
            RequestMappingInfo.RequestMappingInfoComparator comparator = new RequestMappingInfo.RequestMappingInfoComparator();
            matchedInfo.sort(comparator);
            bestMatch = matchedInfo.get(0);
            RequestMappingInfo secondBestMatch = matchedInfo.get(1);
            if (comparator.compare(bestMatch, secondBestMatch) == 0) {
                throw new IllegalStateException("Ambiguous methods mapped for '" + request.getRequestURI() + "': {" + String.valueOf(bestMatch) + ", " + String.valueOf(secondBestMatch) + "}");
            }
        }
        return (Method)this.methods.get(bestMatch);
    }

    private String getPath(HttpServletRequest request) {
        try {
            return new URI(request.getRequestURI()).getPath();
        }
        catch (URISyntaxException e) {
            LOGGER.error("parse request to path error", (Throwable)e);
            throw new NacosRuntimeException(404, "Invalid URI");
        }
    }

    private List<RequestMappingInfo> findMatchedInfo(List<RequestMappingInfo> requestMappingInfos, HttpServletRequest request) {
        ArrayList<RequestMappingInfo> matchedInfo = new ArrayList<RequestMappingInfo>();
        for (RequestMappingInfo requestMappingInfo : requestMappingInfos) {
            ParamRequestCondition matchingCondition = requestMappingInfo.getParamRequestCondition().getMatchingCondition(request);
            if (matchingCondition == null) continue;
            matchedInfo.add(requestMappingInfo);
        }
        return matchedInfo;
    }

    public void initClassMethod(String packageName) {
        DefaultPackageScan packageScan = new DefaultPackageScan();
        Set classesList = packageScan.getTypesAnnotatedWith(packageName, RequestMapping.class);
        for (Class clazz : classesList) {
            this.initClassMethod(clazz);
        }
    }

    public void initClassMethod(Set<Class<?>> classesList) {
        for (Class<?> clazz : classesList) {
            this.initClassMethod(clazz);
        }
    }

    private void initClassMethod(Class<?> clazz) {
        if (this.scannedClass.contains(clazz)) {
            return;
        }
        RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
        for (String classPath : requestMapping.value()) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(RequestMapping.class)) {
                    this.parseSubAnnotations(method, classPath);
                    continue;
                }
                requestMapping = method.getAnnotation(RequestMapping.class);
                RequestMethod[] requestMethods = requestMapping.method();
                if (requestMethods.length == 0) {
                    requestMethods = new RequestMethod[]{RequestMethod.GET};
                }
                for (RequestMethod requestMethod : requestMethods) {
                    String[] value = requestMapping.value();
                    if (value.length > 0) {
                        for (String methodPath : requestMapping.value()) {
                            String urlKey = requestMethod.name() + "-->" + classPath + methodPath;
                            this.addUrlAndMethodRelation(urlKey, requestMapping.params(), method);
                        }
                        continue;
                    }
                    String urlKey = requestMethod.name() + "-->" + classPath;
                    this.addUrlAndMethodRelation(urlKey, requestMapping.params(), method);
                }
            }
        }
        this.scannedClass.add(clazz);
    }

    private void parseSubAnnotations(Method method, String classPath) {
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        PatchMapping patchMapping = method.getAnnotation(PatchMapping.class);
        if (getMapping != null) {
            this.put(RequestMethod.GET, classPath, getMapping.value(), getMapping.params(), method);
        }
        if (postMapping != null) {
            this.put(RequestMethod.POST, classPath, postMapping.value(), postMapping.params(), method);
        }
        if (putMapping != null) {
            this.put(RequestMethod.PUT, classPath, putMapping.value(), putMapping.params(), method);
        }
        if (deleteMapping != null) {
            this.put(RequestMethod.DELETE, classPath, deleteMapping.value(), deleteMapping.params(), method);
        }
        if (patchMapping != null) {
            this.put(RequestMethod.PATCH, classPath, patchMapping.value(), patchMapping.params(), method);
        }
    }

    private void put(RequestMethod requestMethod, String classPath, String[] requestPaths, String[] requestParams, Method method) {
        if (ArrayUtils.isEmpty((Object[])requestPaths)) {
            String urlKey = requestMethod.name() + "-->" + classPath;
            this.addUrlAndMethodRelation(urlKey, requestParams, method);
            return;
        }
        for (String requestPath : requestPaths) {
            String urlKey = requestMethod.name() + "-->" + classPath + requestPath;
            this.addUrlAndMethodRelation(urlKey, requestParams, method);
        }
    }

    private void addUrlAndMethodRelation(String urlKey, String[] requestParam, Method method) {
        RequestMappingInfo requestMappingInfo = new RequestMappingInfo();
        requestMappingInfo.setPathRequestCondition(new PathRequestCondition(urlKey));
        requestMappingInfo.setParamRequestCondition(new ParamRequestCondition(requestParam));
        List requestMappingInfos = (List)this.urlLookup.get(urlKey);
        if (requestMappingInfos == null) {
            this.urlLookup.putIfAbsent(urlKey, new ArrayList());
            requestMappingInfos = (List)this.urlLookup.get(urlKey);
            String urlKeyBackup = urlKey + "/";
            this.urlLookup.putIfAbsent(urlKeyBackup, requestMappingInfos);
        }
        requestMappingInfos.add(requestMappingInfo);
        this.methods.put(requestMappingInfo, method);
    }
}

