/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.lookup;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.MemberLookup;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.cluster.lookup.AddressServerMemberLookup;
import com.alibaba.nacos.core.cluster.lookup.FileConfigMemberLookup;
import com.alibaba.nacos.core.cluster.lookup.StandaloneMemberLookup;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public final class LookupFactory {
    private static final String LOOKUP_MODE_TYPE = "nacos.core.member.lookup.type";
    private static MemberLookup LOOK_UP = null;
    private static LookupType currentLookupType = null;

    public static MemberLookup createLookUp() throws NacosException {
        LookupType type;
        String lookupType = EnvUtil.getProperty((String)LOOKUP_MODE_TYPE);
        currentLookupType = type = LookupFactory.chooseLookup(lookupType);
        return LookupFactory.find(type);
    }

    public static MemberLookup createLookUp(ServerMemberManager memberManager) throws NacosException {
        LOOK_UP = !EnvUtil.getStandaloneMode() ? LookupFactory.createLookUp() : new StandaloneMemberLookup();
        LOOK_UP.injectMemberManager(memberManager);
        Loggers.CLUSTER.info("Current addressing mode selection : {}", (Object)LOOK_UP.getClass().getSimpleName());
        return LOOK_UP;
    }

    public static MemberLookup switchLookup(String name, ServerMemberManager memberManager) throws NacosException {
        LookupType lookupType = LookupType.sourceOf(name);
        if (Objects.isNull((Object)lookupType)) {
            throw new IllegalArgumentException("The addressing mode exists : " + name + ", just support : [" + Arrays.toString((Object[])LookupType.values()) + "]");
        }
        if (Objects.equals((Object)currentLookupType, (Object)lookupType)) {
            return LOOK_UP;
        }
        MemberLookup newLookup = LookupFactory.find(lookupType);
        currentLookupType = lookupType;
        if (Objects.nonNull(LOOK_UP)) {
            LOOK_UP.destroy();
        }
        LOOK_UP = newLookup;
        LOOK_UP.injectMemberManager(memberManager);
        Loggers.CLUSTER.info("Current addressing mode selection : {}", (Object)LOOK_UP.getClass().getSimpleName());
        return LOOK_UP;
    }

    private static MemberLookup find(LookupType type) {
        if (LookupType.FILE_CONFIG.equals((Object)type)) {
            LOOK_UP = new FileConfigMemberLookup();
            return LOOK_UP;
        }
        if (LookupType.ADDRESS_SERVER.equals((Object)type)) {
            LOOK_UP = new AddressServerMemberLookup();
            return LOOK_UP;
        }
        throw new IllegalArgumentException();
    }

    private static LookupType chooseLookup(String lookupType) {
        LookupType type;
        if (StringUtils.isNotBlank((String)lookupType) && Objects.nonNull((Object)(type = LookupType.sourceOf(lookupType)))) {
            return type;
        }
        File file = new File(EnvUtil.getClusterConfFilePath());
        if (file.exists() || StringUtils.isNotBlank((String)EnvUtil.getMemberList())) {
            return LookupType.FILE_CONFIG;
        }
        return LookupType.ADDRESS_SERVER;
    }

    public static MemberLookup getLookUp() {
        return LOOK_UP;
    }

    public static void destroy() throws NacosException {
        Objects.requireNonNull(LOOK_UP).destroy();
    }

    public static enum LookupType {
        FILE_CONFIG(1, "file"),
        ADDRESS_SERVER(2, "address-server");

        private final int code;
        private final String name;

        private LookupType(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public static LookupType sourceOf(String name) {
            for (LookupType type : LookupType.values()) {
                if (!Objects.equals(type.name, name)) continue;
                return type;
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

