/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.lookup;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.cluster.lookup.AbstractMemberLookup;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import com.alibaba.nacos.sys.file.WatchFileCenter;
import java.util.ArrayList;
import java.util.List;

public class FileConfigMemberLookup
extends AbstractMemberLookup {
    private static final String DEFAULT_SEARCH_SEQ = "cluster.conf";
    private FileWatcher watcher = new FileWatcher(){

        public void onChange(FileChangeEvent event) {
            FileConfigMemberLookup.this.readClusterConfFromDisk();
        }

        public boolean interest(String context) {
            return StringUtils.contains((CharSequence)context, (CharSequence)FileConfigMemberLookup.DEFAULT_SEARCH_SEQ);
        }
    };

    @Override
    public void doStart() throws NacosException {
        this.readClusterConfFromDisk();
        try {
            WatchFileCenter.registerWatcher((String)EnvUtil.getConfPath(), (FileWatcher)this.watcher);
        }
        catch (Throwable e) {
            Loggers.CLUSTER.error("An exception occurred in the launch file monitor : {}", (Object)e.getMessage());
        }
    }

    @Override
    public boolean useAddressServer() {
        return false;
    }

    @Override
    protected void doDestroy() throws NacosException {
        WatchFileCenter.deregisterWatcher((String)EnvUtil.getConfPath(), (FileWatcher)this.watcher);
    }

    private void readClusterConfFromDisk() {
        ArrayList<Member> tmpMembers = new ArrayList();
        try {
            List tmp = EnvUtil.readClusterConf();
            tmpMembers = MemberUtil.readServerConf(tmp);
        }
        catch (Throwable e) {
            Loggers.CLUSTER.error("nacos-XXXX [serverlist] failed to get serverlist from disk!, error : {}", (Object)e.getMessage());
        }
        this.afterLookup(tmpMembers);
    }
}

