/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.lookup;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberLookup;
import com.alibaba.nacos.core.cluster.NacosMemberManager;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractMemberLookup
implements MemberLookup {
    protected NacosMemberManager memberManager;
    protected AtomicBoolean start = new AtomicBoolean(false);

    @Override
    public void injectMemberManager(NacosMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @Override
    public void afterLookup(Collection<Member> members) {
        this.memberManager.memberChange(members);
    }

    @Override
    public void destroy() throws NacosException {
        if (this.start.compareAndSet(true, false)) {
            this.doDestroy();
        }
    }

    @Override
    public void start() throws NacosException {
        if (this.start.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    protected abstract void doStart() throws NacosException;

    protected abstract void doDestroy() throws NacosException;
}

