/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.core.cluster.Member;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class MembersChangeEvent
extends Event {
    private static final long serialVersionUID = 7308126651076668976L;
    private final Collection<Member> members;
    private final Collection<Member> triggers;

    private MembersChangeEvent(Collection<Member> members, Collection<Member> triggers) {
        this.members = members;
        this.triggers = new HashSet<Member>();
        if (triggers != null) {
            this.triggers.addAll(triggers);
        }
    }

    public static MemberChangeEventBuilder builder() {
        return new MemberChangeEventBuilder();
    }

    public Collection<Member> getMembers() {
        return this.members;
    }

    public boolean hasTriggers() {
        return !this.triggers.isEmpty();
    }

    public Collection<Member> getTriggers() {
        return this.triggers;
    }

    public String toString() {
        return "MembersChangeEvent{members=" + String.valueOf(this.members) + ", triggers=" + String.valueOf(this.triggers) + ", no=" + this.sequence() + "}";
    }

    public static final class MemberChangeEventBuilder {
        private Collection<Member> allMembers;
        private Collection<Member> triggers;

        private MemberChangeEventBuilder() {
        }

        public MemberChangeEventBuilder members(Collection<Member> allMembers) {
            this.allMembers = allMembers;
            return this;
        }

        public MemberChangeEventBuilder triggers(Collection<Member> triggers) {
            this.triggers = triggers;
            return this;
        }

        public MemberChangeEventBuilder trigger(Member trigger) {
            this.triggers = Collections.singleton(trigger);
            return this;
        }

        public MembersChangeEvent build() {
            return new MembersChangeEvent(this.allMembers, this.triggers);
        }
    }
}

