/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster;

import com.alibaba.nacos.api.common.NodeState;
import com.alibaba.nacos.api.model.response.NacosMember;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class Member
extends NacosMember
implements Comparable<Member>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6061130045021268736L;
    private transient int failAccessCnt = 0;
    @Deprecated
    private boolean grpcReportEnabled;

    public Member() {
        String prefix = "nacos.core.member.meta.";
        super.getExtendInfo().put("site", EnvUtil.getProperty((String)(prefix + "site"), (String)"unknow"));
        super.getExtendInfo().put("adWeight", EnvUtil.getProperty((String)(prefix + "adWeight"), (String)"0"));
        super.getExtendInfo().put("weight", EnvUtil.getProperty((String)(prefix + "weight"), (String)"1"));
    }

    public boolean isGrpcReportEnabled() {
        return this.grpcReportEnabled;
    }

    public void setGrpcReportEnabled(boolean grpcReportEnabled) {
        this.grpcReportEnabled = grpcReportEnabled;
    }

    public static MemberBuilder builder() {
        return new MemberBuilder();
    }

    public Object getExtendVal(String key) {
        return this.getExtendInfo().get(key);
    }

    public void setExtendVal(String key, Object value) {
        this.getExtendInfo().put(key, value);
    }

    public void delExtendVal(String key) {
        this.getExtendInfo().remove(key);
    }

    public boolean check() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getIp(), this.getAddress()}) && this.getPort() != -1;
    }

    public int getFailAccessCnt() {
        return this.failAccessCnt;
    }

    public void setFailAccessCnt(int failAccessCnt) {
        this.failAccessCnt = failAccessCnt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member that = (Member)o;
        return super.equals((Object)that);
    }

    @Override
    public int compareTo(Member o) {
        return this.getAddress().compareTo(o.getAddress());
    }

    public Member copy() {
        Member copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            copy = (Member)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Loggers.CORE.warn("[Member copy] copy failed", (Throwable)e);
        }
        return copy;
    }

    public static final class MemberBuilder {
        private String ip;
        private int port;
        private NodeState state;
        private Map<String, String> extendInfo = Collections.synchronizedMap(new TreeMap());

        private MemberBuilder() {
        }

        public MemberBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public MemberBuilder port(int port) {
            this.port = port;
            return this;
        }

        public MemberBuilder state(NodeState state) {
            this.state = state;
            return this;
        }

        public MemberBuilder extendInfo(Map<String, String> extendInfo) {
            this.extendInfo.putAll(extendInfo);
            return this;
        }

        public Member build() {
            Member serverNode = new Member();
            if (Objects.nonNull(this.extendInfo)) {
                serverNode.getExtendInfo().putAll(this.extendInfo);
            }
            serverNode.setState(this.state);
            serverNode.setIp(this.ip);
            serverNode.setPort(this.port);
            serverNode.setAddress(this.ip + ":" + this.port);
            return serverNode;
        }
    }
}

