/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.auth.config.AuthErrorCode;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.PropertiesUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class NacosServerAuthConfig
extends AbstractDynamicConfig
implements NacosAuthConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosServerAuthConfig.class);
    private static final String PREFIX = "nacos.core.auth.plugin";
    public static final String NACOS_SERVER_AUTH_SCOPE = ApiType.OPEN_API.name();
    private boolean authEnabled;
    private String nacosAuthSystemType;
    private String serverIdentityKey;
    private String serverIdentityValue;
    private Map<String, Properties> authPluginProperties = new HashMap<String, Properties>();

    public NacosServerAuthConfig() {
        super("NacosServerAuth");
        this.resetConfig();
        this.validate();
    }

    private void validate() {
        if (!this.authEnabled) {
            return;
        }
        if (StringUtils.isEmpty((String)this.nacosAuthSystemType)) {
            throw new NacosRuntimeException(AuthErrorCode.INVALID_TYPE.getCode().intValue(), AuthErrorCode.INVALID_TYPE.getMsg());
        }
        if (StringUtils.isEmpty((String)this.serverIdentityKey) || StringUtils.isEmpty((String)this.serverIdentityValue)) {
            throw new NacosRuntimeException(AuthErrorCode.EMPTY_IDENTITY.getCode().intValue(), AuthErrorCode.EMPTY_IDENTITY.getMsg());
        }
    }

    private void refreshPluginProperties() {
        try {
            HashMap<String, Properties> newProperties = new HashMap<String, Properties>(1);
            Properties properties = PropertiesUtil.getPropertiesWithPrefix((Environment)EnvUtil.getEnvironment(), (String)PREFIX);
            if (properties != null) {
                for (String each : properties.stringPropertyNames()) {
                    int typeIndex = each.indexOf(46);
                    String type = each.substring(0, typeIndex);
                    String subKey = each.substring(typeIndex + 1);
                    newProperties.computeIfAbsent(type, key -> new Properties()).setProperty(subKey, properties.getProperty(each));
                }
            }
            this.authPluginProperties = newProperties;
        }
        catch (Exception e) {
            LOGGER.warn("Refresh plugin properties failed ", (Throwable)e);
        }
    }

    public String getAuthScope() {
        return NACOS_SERVER_AUTH_SCOPE;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthSystemType;
    }

    public boolean isSupportServerIdentity() {
        return true;
    }

    public String getServerIdentityKey() {
        return this.serverIdentityKey;
    }

    public String getServerIdentityValue() {
        return this.serverIdentityValue;
    }

    public Properties getAuthPluginProperties(String authType) {
        if (!this.authPluginProperties.containsKey(authType)) {
            LOGGER.warn("Can't find properties for type {}, will use empty properties", (Object)authType);
            return new Properties();
        }
        return this.authPluginProperties.get(authType);
    }

    @Override
    protected void getConfigFromEnv() {
        try {
            this.authEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.enabled", Boolean.class, (Object)false);
            this.nacosAuthSystemType = EnvUtil.getProperty((String)"nacos.core.auth.system.type", (String)"");
            this.serverIdentityKey = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.key", (String)"");
            this.serverIdentityValue = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.value", (String)"");
            this.refreshPluginProperties();
        }
        catch (Exception e) {
            LOGGER.warn("Upgrade auth config from env failed, use old value", (Throwable)e);
        }
    }

    @Override
    protected String printConfig() {
        return this.toString();
    }

    public String toString() {
        return "NacosServerAuthConfig{authEnabled=" + this.authEnabled + ", nacosAuthSystemType='" + this.nacosAuthSystemType + "', serverIdentityKey='" + this.serverIdentityKey + "', serverIdentityValue='" + this.serverIdentityValue + "', authPluginProperties=" + String.valueOf(this.authPluginProperties) + "}";
    }
}

