/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.auth.config.AuthErrorCode;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosServerAdminAuthConfig
extends AbstractDynamicConfig
implements NacosAuthConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosServerAdminAuthConfig.class);
    public static final String NACOS_SERVER_ADMIN_AUTH_SCOPE = ApiType.ADMIN_API.name();
    private boolean authEnabled;
    private String nacosAuthSystemType;
    private String serverIdentityKey;
    private String serverIdentityValue;

    public NacosServerAdminAuthConfig() {
        super("NacosServerAdminAuth");
        this.resetConfig();
        this.validate();
    }

    private void validate() {
        if (!this.authEnabled) {
            return;
        }
        if (StringUtils.isEmpty((String)this.nacosAuthSystemType)) {
            throw new NacosRuntimeException(AuthErrorCode.INVALID_TYPE.getCode().intValue(), AuthErrorCode.INVALID_TYPE.getMsg());
        }
        if (StringUtils.isEmpty((String)this.serverIdentityKey) || StringUtils.isEmpty((String)this.serverIdentityValue)) {
            throw new NacosRuntimeException(AuthErrorCode.EMPTY_IDENTITY.getCode().intValue(), AuthErrorCode.EMPTY_IDENTITY.getMsg());
        }
    }

    public String getAuthScope() {
        return NACOS_SERVER_ADMIN_AUTH_SCOPE;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthSystemType;
    }

    public boolean isSupportServerIdentity() {
        return true;
    }

    public String getServerIdentityKey() {
        return this.serverIdentityKey;
    }

    public String getServerIdentityValue() {
        return this.serverIdentityValue;
    }

    @Override
    protected void getConfigFromEnv() {
        try {
            this.authEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.admin.enabled", Boolean.class, (Object)true);
            this.nacosAuthSystemType = EnvUtil.getProperty((String)"nacos.core.auth.system.type", (String)"");
            this.serverIdentityKey = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.key", (String)"");
            this.serverIdentityValue = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.value", (String)"");
        }
        catch (Exception e) {
            LOGGER.warn("Upgrade auth config from env failed, use old value", (Throwable)e);
        }
    }

    @Override
    protected String printConfig() {
        return this.toString();
    }

    public String toString() {
        return "NacosServerAdminAuthConfig{authEnabled=" + this.authEnabled + ", nacosAuthSystemType='" + this.nacosAuthSystemType + "', serverIdentityKey='" + this.serverIdentityKey + "', serverIdentityValue='" + this.serverIdentityValue + "'}";
    }
}

