/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InnerApiAuthEnabled {
    private final ServerMemberManager serverMemberManager;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public InnerApiAuthEnabled(ServerMemberManager serverMemberManager) {
        this.serverMemberManager = serverMemberManager;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Scheduled(fixedRate=3000L)
    public void doCheck() {
        if (this.enabled.get()) {
            return;
        }
        for (Member each : this.serverMemberManager.allMembers()) {
            String version = (String)each.getExtendVal("version");
            if (!StringUtils.isBlank((CharSequence)version) && version.startsWith("3.")) continue;
            return;
        }
        Loggers.CLUSTER.info("All Nacos server upgrade to upper 3.x, enabled inner api auth identity check");
        this.enabled.set(true);
    }
}

