/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.core.auth.NacosServerAdminAuthConfig;
import com.alibaba.nacos.core.auth.NacosServerAuthConfig;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import com.alibaba.nacos.sys.module.AbstractServerModuleStateBuilder;
import com.alibaba.nacos.sys.module.ModuleState;
import java.util.Optional;

public class AuthModuleStateBuilder
extends AbstractServerModuleStateBuilder {
    public static final String AUTH_MODULE = "auth";
    public static final String AUTH_ENABLED = "auth_enabled";
    public static final String AUTH_SYSTEM_TYPE = "auth_system_type";
    public static final String AUTH_ADMIN_REQUEST = "auth_admin_request";
    private boolean cacheable;

    public ModuleState build() {
        ModuleState result = new ModuleState(AUTH_MODULE);
        boolean authEnabled = NacosAuthConfigHolder.getInstance().isAnyAuthEnabled(new String[]{NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE, NacosServerAdminAuthConfig.NACOS_SERVER_ADMIN_AUTH_SCOPE});
        String authSystemType = NacosAuthConfigHolder.getInstance().getNacosAuthSystemType();
        result.newState(AUTH_ENABLED, (Object)authEnabled);
        result.newState(AUTH_SYSTEM_TYPE, (Object)authSystemType);
        result.newState(AUTH_ADMIN_REQUEST, (Object)this.isAdminRequest(authSystemType));
        return result;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    private Boolean isAdminRequest(String authConfigs) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(authConfigs);
        boolean isAdminRequest = authPluginService.map(AuthPluginService::isAdminRequest).orElse(true);
        if (!isAdminRequest) {
            this.cacheable = true;
        }
        return isAdminRequest;
    }
}

