/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityResult;
import com.alibaba.nacos.core.auth.AbstractWebAuthFilter;
import com.alibaba.nacos.core.auth.InnerApiAuthEnabled;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import jakarta.servlet.http.HttpServletRequest;

public class AuthFilter
extends AbstractWebAuthFilter {
    private final NacosAuthConfig authConfig;
    private final InnerApiAuthEnabled innerApiAuthEnabled;

    public AuthFilter(NacosAuthConfig authConfig, ControllerMethodsCache methodsCache, InnerApiAuthEnabled innerApiAuthEnabled) {
        super(authConfig, methodsCache);
        this.authConfig = authConfig;
        this.innerApiAuthEnabled = innerApiAuthEnabled;
    }

    @Override
    protected boolean isAuthEnabled() {
        return this.authConfig.isAuthEnabled();
    }

    @Override
    protected boolean isMatchFilter(Secured secured) {
        return !ApiType.ADMIN_API.equals((Object)secured.apiType());
    }

    @Override
    protected ServerIdentityResult checkServerIdentity(HttpServletRequest request, Secured secured) {
        if (ApiType.INNER_API.equals((Object)secured.apiType()) && !this.innerApiAuthEnabled.isEnabled()) {
            return ServerIdentityResult.success();
        }
        return super.checkServerIdentity(request, secured);
    }
}

