/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.core.auth.AuthAdminFilter;
import com.alibaba.nacos.core.auth.AuthFilter;
import com.alibaba.nacos.core.auth.InnerApiAuthEnabled;
import com.alibaba.nacos.core.auth.NacosServerAdminAuthConfig;
import com.alibaba.nacos.core.auth.NacosServerAuthConfig;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.web.NacosWebBean;
import jakarta.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@NacosWebBean
public class AuthConfig {
    @Bean
    public FilterRegistrationBean<AuthFilter> authFilterRegistration(AuthFilter authFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)authFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("authFilter");
        registration.setOrder(6);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<AuthAdminFilter> authAdminFilterRegistration(AuthAdminFilter authAdminFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)authAdminFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("authAdminFilter");
        registration.setOrder(6);
        return registration;
    }

    @Bean
    public AuthFilter authFilter(ControllerMethodsCache methodsCache, InnerApiAuthEnabled innerApiAuthEnabled) {
        return new AuthFilter(NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE), methodsCache, innerApiAuthEnabled);
    }

    @Bean
    public AuthAdminFilter authAdminFilter(ControllerMethodsCache methodsCache) {
        return new AuthAdminFilter(NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAdminAuthConfig.NACOS_SERVER_ADMIN_AUTH_SCOPE), methodsCache);
    }
}

