/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.auth.HttpProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityResult;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.context.RequestContext;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.api.AuthResult;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class AbstractWebAuthFilter
implements Filter {
    private final ControllerMethodsCache methodsCache;
    private final HttpProtocolAuthService protocolAuthService;

    protected AbstractWebAuthFilter(NacosAuthConfig authConfig, ControllerMethodsCache methodsCache) {
        this.methodsCache = methodsCache;
        this.protocolAuthService = new HttpProtocolAuthService(authConfig);
        this.protocolAuthService.initialize();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isAuthEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Method method = this.methodsCache.getMethod(req);
        if (method == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!method.isAnnotationPresent(Secured.class)) {
            chain.doFilter(request, response);
            return;
        }
        try {
            Secured secured = method.getAnnotation(Secured.class);
            if (!this.isMatchFilter(secured)) {
                chain.doFilter(request, response);
                return;
            }
            if (Loggers.AUTH.isDebugEnabled()) {
                Loggers.AUTH.debug("auth start, request: {} {}", (Object)req.getMethod(), (Object)req.getRequestURI());
            }
            ServerIdentityResult serverIdentityResult = this.checkServerIdentity(req, secured);
            switch (serverIdentityResult.getStatus()) {
                case FAIL: {
                    resp.sendError(403, serverIdentityResult.getMessage());
                    return;
                }
                case MATCHED: {
                    chain.doFilter(request, response);
                    return;
                }
            }
            if (!this.protocolAuthService.enableAuth(secured)) {
                chain.doFilter(request, response);
                return;
            }
            Resource resource = this.protocolAuthService.parseResource(req, secured);
            IdentityContext identityContext = this.protocolAuthService.parseIdentity(req);
            AuthResult result = this.protocolAuthService.validateIdentity(identityContext, resource);
            RequestContext requestContext = RequestContextHolder.getContext();
            requestContext.getAuthContext().setIdentityContext(identityContext);
            requestContext.getAuthContext().setResource(resource);
            requestContext.getAuthContext().setAuthResult(result);
            if (!result.isSuccess()) {
                throw new AccessException(result.format());
            }
            if (this.isIdentityOnlyApi(secured)) {
                if (Loggers.AUTH.isDebugEnabled()) {
                    Loggers.AUTH.debug("API is identity only, skip validate authority, request: {} {}", (Object)req.getMethod(), (Object)req.getRequestURI());
                }
                chain.doFilter(request, response);
                return;
            }
            String action = secured.action().toString();
            result = this.protocolAuthService.validateAuthority(identityContext, new Permission(resource, action));
            if (!result.isSuccess()) {
                throw new AccessException(result.format());
            }
            chain.doFilter(request, response);
        }
        catch (AccessException e) {
            if (Loggers.AUTH.isDebugEnabled()) {
                Loggers.AUTH.debug("access denied, request: {} {}, reason: {}", new Object[]{req.getMethod(), req.getRequestURI(), e.getErrMsg()});
            }
            resp.sendError(403, e.getErrMsg());
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
        catch (Exception e) {
            Loggers.AUTH.warn("[AUTH-FILTER] Server failed: ", (Throwable)e);
        }
    }

    private boolean isIdentityOnlyApi(Secured secured) {
        for (String tag : secured.tags()) {
            if (!"only_identity".equals(tag)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatchFilter(Secured secured) {
        return true;
    }

    protected ServerIdentityResult checkServerIdentity(HttpServletRequest request, Secured secured) {
        return this.protocolAuthService.checkServerIdentity((Object)request, secured);
    }

    protected abstract boolean isAuthEnabled();
}

