/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.connection.ConnectionControlManager;
import com.alibaba.nacos.plugin.control.connection.DefaultConnectionControlManager;
import com.alibaba.nacos.plugin.control.event.ConnectionLimitRuleChangeEvent;
import com.alibaba.nacos.plugin.control.event.TpsControlRuleChangeEvent;
import com.alibaba.nacos.plugin.control.rule.storage.RuleStorageProxy;
import com.alibaba.nacos.plugin.control.spi.ControlManagerBuilder;
import com.alibaba.nacos.plugin.control.tps.DefaultTpsControlManager;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import java.util.Optional;

public class ControlManagerCenter {
    static volatile ControlManagerCenter instance = null;
    private final RuleStorageProxy ruleStorageProxy = RuleStorageProxy.getInstance();
    private TpsControlManager tpsControlManager;
    private ConnectionControlManager connectionControlManager;

    private ControlManagerCenter() {
        Optional<ControlManagerBuilder> controlManagerBuilder = this.findTargetControlManagerBuilder();
        if (controlManagerBuilder.isPresent()) {
            this.initConnectionManager(controlManagerBuilder.get());
            this.initTpsControlManager(controlManagerBuilder.get());
        } else {
            this.buildNoLimitControlManagers();
        }
    }

    private void initConnectionManager(ControlManagerBuilder controlManagerBuilder) {
        try {
            this.connectionControlManager = controlManagerBuilder.buildConnectionControlManager();
            Loggers.CONTROL.info("Build connection control manager, class={}", (Object)this.connectionControlManager.getClass().getCanonicalName());
        }
        catch (Exception e) {
            Loggers.CONTROL.warn("Build connection control manager failed, use no limit manager replaced.", (Throwable)e);
            this.connectionControlManager = new DefaultConnectionControlManager();
        }
    }

    private void initTpsControlManager(ControlManagerBuilder controlManagerBuilder) {
        try {
            this.tpsControlManager = controlManagerBuilder.buildTpsControlManager();
            Loggers.CONTROL.info("Build tps control manager, class={}", (Object)this.tpsControlManager.getClass().getCanonicalName());
        }
        catch (Exception e) {
            Loggers.CONTROL.warn("Build tps control manager failed, use no limit manager replaced.", (Throwable)e);
            this.tpsControlManager = new DefaultTpsControlManager();
        }
    }

    private Optional<ControlManagerBuilder> findTargetControlManagerBuilder() {
        String controlManagerType = ControlConfigs.getInstance().getControlManagerType();
        if (StringUtils.isEmpty((String)controlManagerType)) {
            Loggers.CONTROL.info("Not configure type of control plugin, no limit control for current node.");
            return Optional.empty();
        }
        for (ControlManagerBuilder each : NacosServiceLoader.load(ControlManagerBuilder.class)) {
            Loggers.CONTROL.info("Found control manager plugin of name={}", (Object)each.getName());
            if (!controlManagerType.equalsIgnoreCase(each.getName())) continue;
            return Optional.of(each);
        }
        Loggers.CONTROL.warn("Not found control manager plugin of name");
        return Optional.empty();
    }

    private void buildNoLimitControlManagers() {
        this.connectionControlManager = new DefaultConnectionControlManager();
        this.tpsControlManager = new DefaultTpsControlManager();
    }

    public RuleStorageProxy getRuleStorageProxy() {
        return this.ruleStorageProxy;
    }

    public TpsControlManager getTpsControlManager() {
        return this.tpsControlManager;
    }

    public ConnectionControlManager getConnectionControlManager() {
        return this.connectionControlManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ControlManagerCenter getInstance() {
        if (instance != null) return instance;
        Class<ControlManagerCenter> clazz = ControlManagerCenter.class;
        synchronized (ControlManagerCenter.class) {
            if (instance != null) return instance;
            instance = new ControlManagerCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void reloadTpsControlRule(String pointName, boolean external) {
        NotifyCenter.publishEvent((Event)new TpsControlRuleChangeEvent(pointName, external));
    }

    public void reloadConnectionControlRule(boolean external) {
        NotifyCenter.publishEvent((Event)new ConnectionLimitRuleChangeEvent(external));
    }
}

