/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.naming;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.builder.InstanceBuilder;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.console.proxy.naming.InstanceProxy;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.model.form.InstanceForm;
import com.alibaba.nacos.naming.model.form.InstanceListForm;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/ns/instance"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class ConsoleInstanceController {
    private final InstanceProxy instanceProxy;

    public ConsoleInstanceController(InstanceProxy instanceProxy) {
        this.instanceProxy = instanceProxy;
    }

    @Secured(action=ActionTypes.READ, apiType=ApiType.CONSOLE_API)
    @RequestMapping(value={"/list"})
    public Result<Page<? extends Instance>> getInstanceList(InstanceListForm instanceForm, PageForm pageForm) throws NacosException {
        instanceForm.validate();
        Page<? extends Instance> instancePage = this.instanceProxy.listInstances(instanceForm.getNamespaceId(), instanceForm.getServiceName(), instanceForm.getGroupName(), instanceForm.getClusterName(), pageForm.getPageNo(), pageForm.getPageSize());
        return Result.success(instancePage);
    }

    @CanDistro
    @PutMapping
    @TpsControl(pointName="NamingInstanceUpdate", name="HttpNamingInstanceUpdate")
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.CONSOLE_API)
    public Result<String> updateInstance(InstanceForm instanceForm) throws NacosException {
        instanceForm.validate();
        this.checkWeight(instanceForm.getWeight());
        Instance instance = this.buildInstance(instanceForm);
        this.instanceProxy.updateInstance(instanceForm, instance);
        return Result.success((Object)"ok");
    }

    private void checkWeight(Double weight) throws NacosException {
        if (weight > 10000.0 || weight < 0.0) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.WEIGHT_ERROR, "instance format invalid: The weights range from 0.0 to 10000.0");
        }
    }

    private Instance buildInstance(InstanceForm instanceForm) throws NacosException {
        Instance instance = InstanceBuilder.newBuilder().setServiceName(this.buildCompositeServiceName(instanceForm)).setIp(instanceForm.getIp()).setClusterName(instanceForm.getClusterName()).setPort(instanceForm.getPort()).setHealthy(instanceForm.getHealthy()).setWeight(instanceForm.getWeight()).setEnabled(instanceForm.getEnabled()).setMetadata(UtilsAndCommons.parseMetadata((String)instanceForm.getMetadata())).setEphemeral(instanceForm.getEphemeral()).build();
        if (instanceForm.getEphemeral() == null) {
            instance.setEphemeral(false);
        }
        return instance;
    }

    private String buildCompositeServiceName(InstanceForm instanceForm) {
        return NamingUtils.getGroupedName((String)instanceForm.getServiceName(), (String)instanceForm.getGroupName());
    }
}

