/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.config;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.paramcheck.ConfigBlurSearchHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.console.proxy.config.ConfigProxy;
import com.alibaba.nacos.core.model.form.AggregationForm;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/cs/config"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConsoleConfigController {
    private final ConfigProxy configProxy;

    public ConsoleConfigController(ConfigProxy configProxy) {
        this.configProxy = configProxy;
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<ConfigDetailInfo> getConfigDetail(ConfigFormV3 configForm) throws NacosException {
        configForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        return Result.success((Object)this.configProxy.getConfigDetail(dataId, groupName, namespaceId));
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<Boolean> publishConfig(HttpServletRequest request, ConfigFormV3 configForm) throws NacosException {
        configForm.validateWithContent();
        boolean namespaceTransferred = NamespaceUtil.isNeedTransferNamespace((String)configForm.getNamespaceId());
        configForm.setNamespaceId(NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId()));
        ParamUtils.checkParam((String)configForm.getDataId(), (String)configForm.getGroup(), (String)"datumId", (String)configForm.getContent());
        ParamUtils.checkParamV2((String)configForm.getTag());
        if (StringUtils.isBlank((CharSequence)configForm.getSrcUser())) {
            configForm.setSrcUser(RequestUtil.getSrcUserName((HttpServletRequest)request));
        }
        if (!ConfigType.isValidType((String)configForm.getType()).booleanValue()) {
            configForm.setType(ConfigType.getDefaultType().getType());
        }
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp((HttpServletRequest)request));
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName((HttpServletRequest)request));
        configRequestInfo.setBetaIps(request.getHeader("betaIps"));
        configRequestInfo.setCasMd5(request.getHeader("casMd5"));
        configRequestInfo.setNamespaceTransferred(namespaceTransferred);
        return Result.success((Object)this.configProxy.publishConfig((ConfigForm)configForm, configRequestInfo));
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<Boolean> deleteConfig(HttpServletRequest request, ConfigFormV3 configForm) throws NacosException {
        configForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        ParamUtils.checkParamV2((String)configForm.getTag());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String tag = configForm.getTag();
        String clientIp = RequestUtil.getRemoteIp((HttpServletRequest)request);
        String srcUser = RequestUtil.getSrcUserName((HttpServletRequest)request);
        return Result.success((Object)this.configProxy.deleteConfig(dataId, groupName, namespaceId, tag, clientIp, srcUser));
    }

    @DeleteMapping(value={"/batchDelete"})
    @Secured(action=ActionTypes.WRITE, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<Boolean> batchDeleteConfigs(HttpServletRequest request, @RequestParam(value="ids") List<Long> ids) throws NacosException {
        String clientIp = RequestUtil.getRemoteIp((HttpServletRequest)request);
        String srcUser = RequestUtil.getSrcUserName((HttpServletRequest)request);
        return Result.success((Object)this.configProxy.batchDeleteConfigs(ids, clientIp, srcUser));
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    public Result<Page<ConfigBasicInfo>> getConfigList(ConfigFormV3 configForm, PageForm pageForm) throws IOException, ServletException, NacosException {
        configForm.blurSearchValidate();
        pageForm.validate();
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((String)configForm.getAppName())) {
            configAdvanceInfo.put("appName", configForm.getAppName());
        }
        if (StringUtils.isNotBlank((String)configForm.getConfigTags())) {
            configAdvanceInfo.put("config_tags", configForm.getConfigTags());
        }
        if (StringUtils.isNotBlank((String)configForm.getType())) {
            configAdvanceInfo.put("types", configForm.getType());
        }
        int pageNo = pageForm.getPageNo();
        int pageSize = pageForm.getPageSize();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        return Result.success(this.configProxy.getConfigList(pageNo, pageSize, dataId, groupName, namespaceId, configAdvanceInfo));
    }

    @GetMapping(value={"/searchDetail"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    public Result<Page<ConfigBasicInfo>> getConfigListByContent(ConfigFormV3 configForm, PageForm pageForm, String configDetail, @RequestParam(defaultValue="blur") String search) throws NacosException {
        configForm.blurSearchValidate();
        pageForm.validate();
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((String)configForm.getAppName())) {
            configAdvanceInfo.put("appName", configForm.getAppName());
        }
        if (StringUtils.isNotBlank((String)configForm.getConfigTags())) {
            configAdvanceInfo.put("config_tags", configForm.getConfigTags());
        }
        if (StringUtils.isNotBlank((String)configForm.getType())) {
            configAdvanceInfo.put("types", configForm.getType());
        }
        if (StringUtils.isNotBlank((String)configDetail)) {
            configAdvanceInfo.put("content", configDetail);
        }
        int pageNo = pageForm.getPageNo();
        int pageSize = pageForm.getPageSize();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        return Result.success(this.configProxy.getConfigListByContent(search, pageNo, pageSize, dataId, groupName, namespaceId, configAdvanceInfo));
    }

    @GetMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<ConfigListenerInfo> getListeners(ConfigFormV3 configForm, AggregationForm aggregationForm) throws Exception {
        configForm.validate();
        aggregationForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String groupName = configForm.getGroupName();
        String dataId = configForm.getDataId();
        return Result.success((Object)this.configProxy.getListeners(dataId, groupName, namespaceId, aggregationForm.isAggregation()));
    }

    @GetMapping(value={"/listener/ip"})
    @Secured(resource="/v1/cs/listener", action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<ConfigListenerInfo> getAllSubClientConfigByIp(@RequestParam(value="ip") String ip, @RequestParam(value="all", required=false) boolean all, @RequestParam(value="namespaceId", required=false) String namespaceId, AggregationForm aggregationForm) throws NacosException {
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        return Result.success((Object)this.configProxy.getAllSubClientConfigByIp(ip, all, namespaceId, aggregationForm.isAggregation()));
    }

    @GetMapping(value={"/export2"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public ResponseEntity<byte[]> exportConfigV2(ConfigFormV3 configForm, @RequestParam(value="ids", required=false) List<Long> ids) throws Exception {
        configForm.blurSearchValidate();
        ids.removeAll(Collections.singleton(null));
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String appName = configForm.getAppName();
        return this.configProxy.exportConfigV2(dataId, groupName, namespaceId, appName, ids);
    }

    @PostMapping(value={"/import"})
    @Secured(action=ActionTypes.WRITE, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<Map<String, Object>> importAndPublishConfig(HttpServletRequest request, @RequestParam(required=false) String srcUser, @RequestParam(value="namespaceId", required=false) String namespaceId, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy, MultipartFile file) throws NacosException {
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName((HttpServletRequest)request);
        }
        String srcIp = RequestUtil.getRemoteIp((HttpServletRequest)request);
        String requestIpApp = RequestUtil.getAppName((HttpServletRequest)request);
        return this.configProxy.importAndPublishConfig(srcUser, namespaceId, policy, file, srcIp, requestIpApp);
    }

    @PostMapping(value={"/clone"})
    @Secured(action=ActionTypes.WRITE, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<Map<String, Object>> cloneConfig(HttpServletRequest request, @RequestParam(required=false) String srcUser, @RequestParam(value="targetNamespaceId") String namespaceId, @RequestBody List<SameNamespaceCloneConfigBean> configBeansList, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy) throws NacosException {
        configBeansList.removeAll(Collections.singleton(null));
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName((HttpServletRequest)request);
        }
        String srcIp = RequestUtil.getRemoteIp((HttpServletRequest)request);
        String requestIpApp = RequestUtil.getAppName((HttpServletRequest)request);
        return this.configProxy.cloneConfig(srcUser, namespaceId, configBeansList, policy, srcIp, requestIpApp);
    }

    @DeleteMapping(value={"/beta"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Result<Boolean> stopBeta(HttpServletRequest httpServletRequest, ConfigFormV3 configForm) throws NacosException {
        configForm.validate();
        String remoteIp = RequestUtil.getRemoteIp((HttpServletRequest)httpServletRequest);
        String requestIpApp = RequestUtil.getAppName((HttpServletRequest)httpServletRequest);
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String srcUser = RequestUtil.getSrcUserName((HttpServletRequest)httpServletRequest);
        boolean success = this.configProxy.removeBetaConfig(dataId, groupName, namespaceId, remoteIp, requestIpApp, srcUser);
        if (!success) {
            return Result.failure((Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Object)false);
        }
        return Result.success((Object)true);
    }

    @GetMapping(value={"/beta"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Result<ConfigGrayInfo> queryBeta(ConfigFormV3 configForm) throws NacosException {
        configForm.validate();
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        return Result.success((Object)this.configProxy.queryBetaConfig(dataId, groupName, namespaceId));
    }
}

