/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.config;

import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.console.config.NacosConsoleAuthConfig;
import com.alibaba.nacos.console.filter.NacosConsoleAuthFilter;
import com.alibaba.nacos.console.filter.XssFilter;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.controller.compatibility.ApiCompatibilityFilter;
import com.alibaba.nacos.core.exception.NacosApiExceptionHandler;
import com.alibaba.nacos.core.paramcheck.ParamCheckerFilter;
import jakarta.servlet.Filter;
import java.time.ZoneId;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class ConsoleWebConfig {
    private final ControllerMethodsCache methodsCache;

    public ConsoleWebConfig(ControllerMethodsCache methodsCache) {
        this.methodsCache = methodsCache;
    }

    @PostConstruct
    public void init() {
        this.methodsCache.initClassMethod("com.alibaba.nacos.console.controller");
    }

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedHeader("*");
        config.setMaxAge(Long.valueOf(18000L));
        config.addAllowedMethod("*");
        config.addAllowedOriginPattern("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public XssFilter xssFilter() {
        return new XssFilter();
    }

    @Bean
    public FilterRegistrationBean<NacosConsoleAuthFilter> authFilterRegistration(NacosConsoleAuthFilter authFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)authFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("consoleAuthFilter");
        registration.setOrder(6);
        return registration;
    }

    @Bean
    public NacosConsoleAuthFilter consoleAuthFilter(ControllerMethodsCache methodsCache) {
        return new NacosConsoleAuthFilter(NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosConsoleAuthConfig.NACOS_CONSOLE_AUTH_SCOPE), methodsCache);
    }

    @Bean
    public FilterRegistrationBean<ParamCheckerFilter> consoleParamCheckerFilterRegistration(ParamCheckerFilter consoleParamCheckerFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)consoleParamCheckerFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("consoleParamCheckerFilter");
        registration.setOrder(8);
        return registration;
    }

    @Bean
    public ParamCheckerFilter consoleParamCheckerFilter(ControllerMethodsCache methodsCache) {
        return new ParamCheckerFilter(methodsCache);
    }

    @Bean
    public ApiCompatibilityFilter consoleApiCompatibilityFilter(ControllerMethodsCache methodsCache) {
        return new ApiCompatibilityFilter(methodsCache, null);
    }

    @Bean
    public FilterRegistrationBean<ApiCompatibilityFilter> consoleApiCompatibilityFilterRegistration(ApiCompatibilityFilter consoleApiCompatibilityFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)consoleApiCompatibilityFilter);
        registration.addUrlPatterns(new String[]{"/v1/*", "/v2/*"});
        registration.setName("consoleApiCompatibilityFilter");
        registration.setOrder(5);
        return registration;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jacksonObjectMapperCustomization() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.timeZone(ZoneId.systemDefault().toString());
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(new String[]{"/**"})).permitAll());
        http.csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public NacosApiExceptionHandler nacosApiExceptionHandler() {
        return new NacosApiExceptionHandler();
    }
}

