/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.cluster;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberLookup;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.NacosMemberManager;
import com.alibaba.nacos.core.cluster.lookup.LookupFactory;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
@EnabledRemoteHandler
public class RemoteServerMemberManager
implements NacosMemberManager {
    private volatile ConcurrentSkipListMap<String, Member> serverList = new ConcurrentSkipListMap();
    private MemberLookup lookup;

    @PostConstruct
    public void init() throws NacosException {
        this.initAndStartLookup();
    }

    private void initAndStartLookup() throws NacosException {
        this.lookup = LookupFactory.createLookUp();
        this.lookup.injectMemberManager((NacosMemberManager)this);
        this.lookup.start();
    }

    public synchronized boolean memberChange(Collection<Member> members) {
        ConcurrentSkipListMap<String, Member> newServerList = new ConcurrentSkipListMap<String, Member>();
        for (Member each : members) {
            newServerList.put(each.getAddress(), each);
        }
        Loggers.CLUSTER.info("[serverlist] nacos remote server members changed to : {}", newServerList);
        this.serverList = newServerList;
        MembersChangeEvent event = MembersChangeEvent.builder().members(members).build();
        NotifyCenter.publishEvent((Event)event);
        return true;
    }

    public Collection<Member> allMembers() {
        return new HashSet<Member>(this.serverList.values());
    }
}

