/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigHistoryBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigHistoryDetailInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.utils.LogUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.BeanUtils;

public class ResponseUtil {
    public static void writeErrMsg(HttpServletResponse response, int httpCode, String msg) {
        response.setStatus(httpCode);
        try {
            response.getWriter().println(msg);
        }
        catch (IOException e) {
            LogUtil.DEFAULT_LOG.error("ResponseUtil:writeErrMsg wrong", (Throwable)e);
        }
    }

    public static ConfigDetailInfo transferToConfigDetailInfo(ConfigAllInfo configAllInfo) {
        ConfigDetailInfo result = new ConfigDetailInfo();
        BeanUtils.copyProperties((Object)configAllInfo, (Object)result);
        result.setNamespaceId(configAllInfo.getTenant());
        result.setGroupName(configAllInfo.getGroup());
        return result;
    }

    public static ConfigBasicInfo transferToConfigBasicInfo(ConfigInfo configInfo) {
        ConfigBasicInfo result = new ConfigBasicInfo();
        BeanUtils.copyProperties((Object)configInfo, (Object)result);
        result.setNamespaceId(configInfo.getTenant());
        result.setGroupName(configInfo.getGroup());
        return result;
    }

    public static ConfigBasicInfo transferToConfigBasicInfo(ConfigInfoWrapper configInfo) {
        ConfigBasicInfo result = ResponseUtil.transferToConfigBasicInfo((ConfigInfo)configInfo);
        result.setModifyTime(configInfo.getLastModified());
        return result;
    }

    public static ConfigGrayInfo transferToConfigGrayInfo(ConfigInfoGrayWrapper configInfoGray) {
        ConfigGrayInfo result = new ConfigGrayInfo();
        BeanUtils.copyProperties((Object)configInfoGray, (Object)result);
        result.setNamespaceId(configInfoGray.getTenant());
        result.setGroupName(configInfoGray.getGroup());
        result.setCreateUser(configInfoGray.getSrcUser());
        result.setModifyTime(configInfoGray.getLastModified());
        return result;
    }

    public static ConfigHistoryBasicInfo transferToConfigHistoryBasicInfo(ConfigHistoryInfo historyInfo) {
        ConfigHistoryBasicInfo result = new ConfigHistoryBasicInfo();
        BeanUtils.copyProperties((Object)historyInfo, (Object)result);
        ResponseUtil.injectHistoryBasicInfo(result, historyInfo);
        return result;
    }

    public static ConfigHistoryDetailInfo transferToConfigHistoryDetailInfo(ConfigHistoryInfo historyInfo) {
        ConfigHistoryDetailInfo result = new ConfigHistoryDetailInfo();
        BeanUtils.copyProperties((Object)historyInfo, (Object)result);
        ResponseUtil.injectHistoryBasicInfo((ConfigHistoryBasicInfo)result, historyInfo);
        return result;
    }

    private static void injectHistoryBasicInfo(ConfigHistoryBasicInfo historyBasicInfo, ConfigHistoryInfo historyInfo) {
        historyBasicInfo.setNamespaceId(historyInfo.getTenant());
        historyBasicInfo.setGroupName(historyInfo.getGroup());
        historyBasicInfo.setCreateTime(historyInfo.getCreatedTime().getTime());
        historyBasicInfo.setModifyTime(historyInfo.getLastModifiedTime().getTime());
    }
}

