/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.HistoryConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalHistoryConfigInfoPersistServiceImpl")
public class ExternalHistoryConfigInfoPersistServiceImpl
implements HistoryConfigInfoPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalHistoryConfigInfoPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public void insertConfigHistoryAtomic(long id, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops, String publishType, String grayName, String extInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = StringUtils.defaultEmptyIfBlank((String)configInfo.getEncryptedDataKey());
        String publishTypeTmp = StringUtils.defaultEmptyIfBlank((String)publishType);
        String grayNameTemp = StringUtils.defaultEmptyIfBlank((String)grayName);
        try {
            HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
            this.jt.update(historyConfigInfoMapper.insert(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_modified", "op_type", "publish_type", "gray_name", "ext_info", "encrypted_data_key")), new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops, publishTypeTmp, grayNameTemp, extInfo, encryptedDataKey});
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("startTime", (Object)startTime);
        context.putWhereParameter("limitSize", (Object)limitSize);
        MapperResult mapperResult = historyConfigInfoMapper.removeConfigHistory(context);
        PaginationHelper paginationHelper = this.createPaginationHelper();
        paginationHelper.updateLimit(mapperResult.getSql(), mapperResult.getParamList().toArray());
    }

    @Override
    public List<ConfigInfoStateWrapper> findDeletedConfig(Timestamp startTime, long startId, int pageSize, String publishType) {
        try {
            HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
            MapperContext context = new MapperContext();
            context.putWhereParameter("startTime", (Object)startTime);
            context.putWhereParameter("pageSize", (Object)pageSize);
            context.putWhereParameter("lastMaxId", (Object)startId);
            context.putWhereParameter("publishType", (Object)publishType);
            MapperResult mapperResult = historyConfigInfoMapper.findDeletedConfig(context);
            List configHistoryInfos = this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
            ArrayList<ConfigInfoStateWrapper> configInfoStateWrappers = new ArrayList<ConfigInfoStateWrapper>();
            for (ConfigHistoryInfo configHistoryInfo : configHistoryInfos) {
                ConfigInfoStateWrapper configInfoStateWrapper = new ConfigInfoStateWrapper();
                configInfoStateWrapper.setId(configHistoryInfo.getId());
                configInfoStateWrapper.setDataId(configHistoryInfo.getDataId());
                configInfoStateWrapper.setGroup(configHistoryInfo.getGroup());
                configInfoStateWrapper.setTenant(configHistoryInfo.getTenant());
                configInfoStateWrapper.setMd5(configHistoryInfo.getMd5());
                configInfoStateWrapper.setLastModified(configHistoryInfo.getLastModifiedTime().getTime());
                configInfoStateWrapper.setGrayName(configHistoryInfo.getGrayName());
                configInfoStateWrappers.add(configInfoStateWrapper);
            }
            return configInfoStateWrappers;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        Page page;
        PaginationHelper helper = this.createPaginationHelper();
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        MapperContext context = new MapperContext((pageNo - 1) * pageSize, pageSize);
        context.putWhereParameter("dataId", (Object)dataId);
        context.putWhereParameter("groupId", (Object)group);
        context.putWhereParameter("tenantId", (Object)tenantTmp);
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlCountRows = historyConfigInfoMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        MapperResult sqlFetchRows = historyConfigInfoMapper.pageFindConfigHistoryFetchRows(context);
        try {
            page = helper.fetchPage(sqlCountRows, sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.HISTORY_LIST_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[list-config-history] error, dataId:{}, group:{}", (Object)new Object[]{dataId, group}, (Object)e);
            throw e;
        }
        return page;
    }

    @Override
    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlFetchRows = historyConfigInfoMapper.select(Arrays.asList("nid", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_user", "src_ip", "op_type", "gmt_create", "gmt_modified", "publish_type", "gray_name", "ext_info", "encrypted_data_key"), Collections.singletonList("nid"));
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows, new Object[]{nid}, (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[detail-config-history] error, nid:{}", (Object)new Object[]{nid}, (Object)e);
            throw e;
        }
    }

    @Override
    public ConfigHistoryInfo detailPreviousConfigHistory(Long id) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)id);
        MapperResult sqlFetchRows = historyConfigInfoMapper.detailPreviousConfigHistory(context);
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[detail-previous-config-history] error, id:{}", (Object)new Object[]{id}, (Object)e);
            throw e;
        }
    }

    @Override
    public int findConfigHistoryCountByTime(Timestamp startTime) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("startTime", (Object)startTime);
        MapperResult mapperResult = historyConfigInfoMapper.findConfigHistoryCountByTime(context);
        Integer result = (Integer)this.jt.queryForObject(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("findConfigHistoryCountByTime error");
        }
        return result;
    }

    @Override
    public ConfigHistoryInfo getNextHistoryInfo(String dataId, String group, String tenant, String publishType, String grayName, long startNid) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("dataId", (Object)dataId);
        context.putWhereParameter("groupId", (Object)group);
        context.putWhereParameter("tenantId", (Object)tenant);
        context.putWhereParameter("publishType", (Object)publishType);
        context.putWhereParameter("nid", (Object)startNid);
        context.putWhereParameter("grayName", (Object)grayName);
        MapperResult sqlFetchRows = historyConfigInfoMapper.getNextHistoryInfo(context);
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }
}

