/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigMigratePersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoGrayMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigMigrateMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigMigratePersistServiceImpl")
public class EmbeddedConfigMigratePersistServiceImpl
implements ConfigMigratePersistService {
    private static final String RESOURCE_CONFIG_INFO_ID = "config-info-id";
    private static final String RESOURCE_CONFIG_HISTORY_GRAY_ID = "config-history-gray-id";
    private final DatabaseOperate databaseOperate;
    private final IdGeneratorManager idGeneratorManager;
    private DataSourceService dataSourceService;
    private MapperManager mapperManager;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoGrayPersistService configInfoGrayPersistService;

    public EmbeddedConfigMigratePersistServiceImpl(DatabaseOperate databaseOperate, IdGeneratorManager idGeneratorManager, @Qualifier(value="embeddedConfigInfoPersistServiceImpl") ConfigInfoPersistService configInfoPersistService, @Qualifier(value="embeddedConfigInfoGrayPersistServiceImpl") ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.databaseOperate = databaseOperate;
        this.idGeneratorManager = idGeneratorManager;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        idGeneratorManager.register(new String[]{RESOURCE_CONFIG_INFO_ID, RESOURCE_CONFIG_HISTORY_GRAY_ID});
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public Integer configInfoConflictCount(String srcUser) {
        ConfigMigrateMapper configInfoMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        MapperResult mapperResult = configInfoMigrateMapper.getConfigConflictCount(context);
        Integer result = (Integer)this.databaseOperate.queryOne(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoConflictCount error");
        }
        return result;
    }

    @Override
    public Integer configInfoGrayConflictCount(String srcUser) {
        ConfigMigrateMapper configInfoMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        MapperResult mapperResult = configInfoMigrateMapper.getConfigGrayConflictCount(context);
        Integer result = (Integer)this.databaseOperate.queryOne(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoGrayConflictCount error");
        }
        return result;
    }

    @Override
    public List<Long> getMigrateConfigInsertIdList(long startId, int pageSize) {
        ConfigMigrateMapper configInfoMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)startId);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configInfoMigrateMapper.findConfigIdNeedInsertMigrate(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), Long.class);
    }

    @Override
    public List<Long> getMigrateConfigGrayInsertIdList(long startId, int pageSize) {
        ConfigMigrateMapper configInfoMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)startId);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configInfoMigrateMapper.findConfigGrayIdNeedInsertMigrate(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), Long.class);
    }

    @Override
    public List<ConfigInfo> getMigrateConfigUpdateList(long startId, int pageSize, String srcTenant, String targetTenant, String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        context.putWhereParameter("id", (Object)startId);
        context.putWhereParameter("srcTenant", (Object)srcTenant);
        context.putWhereParameter("targetTenant", (Object)targetTenant);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configMigrateMapper.findConfigNeedUpdateMigrate(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoGrayWrapper> getMigrateConfigGrayUpdateList(long startId, int pageSize, String srcTenant, String targetTenant, String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        context.putWhereParameter("id", (Object)startId);
        context.putWhereParameter("srcTenant", (Object)srcTenant);
        context.putWhereParameter("targetTenant", (Object)targetTenant);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configMigrateMapper.findConfigGrayNeedUpdateMigrate(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
    }

    @Override
    public void migrateConfigInsertByIds(List<Long> ids, String srcUser) {
        ConfigMigrateMapper configInfoMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        for (Long targetId : ids) {
            long configId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_INFO_ID);
            MapperContext context = new MapperContext();
            context.putWhereParameter("targetId", (Object)targetId);
            context.putWhereParameter("srcUser", (Object)srcUser);
            context.putWhereParameter("id", (Object)configId);
            MapperResult result = configInfoMigrateMapper.migrateConfigInsertByIds(context);
            EmbeddedStorageContextHolder.addSqlContext((String)result.getSql(), (Object[])result.getParamList().toArray());
        }
        this.databaseOperate.blockUpdate();
    }

    @Override
    public void migrateConfigGrayInsertByIds(List<Long> ids, String srcUser) {
        ConfigMigrateMapper configInfoMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        for (Long targetId : ids) {
            long configId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_GRAY_ID);
            MapperContext context = new MapperContext();
            context.putWhereParameter("targetId", (Object)targetId);
            context.putWhereParameter("id", (Object)configId);
            context.putWhereParameter("srcUser", (Object)srcUser);
            MapperResult result = configInfoMigrateMapper.migrateConfigGrayInsertByIds(context);
            EmbeddedStorageContextHolder.addSqlContext((String)result.getSql(), (Object[])result.getParamList().toArray());
        }
        this.databaseOperate.blockUpdate();
    }

    @Override
    public void syncConfig(String dataId, String group, String tenant, String targetTenant, String srcUser) {
        ConfigInfoWrapper sourceConfigInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
        ConfigInfoWrapper targetConfigInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, targetTenant);
        if (sourceConfigInfoWrapper == null) {
            this.configInfoPersistService.removeConfigInfo(dataId, group, targetTenant, null, srcUser);
        } else if (targetConfigInfoWrapper == null) {
            sourceConfigInfoWrapper.setTenant(targetTenant);
            long configId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_INFO_ID);
            this.configInfoPersistService.addConfigInfoAtomic(configId, null, srcUser, sourceConfigInfoWrapper, null);
        } else if (sourceConfigInfoWrapper.getLastModified() >= targetConfigInfoWrapper.getLastModified()) {
            sourceConfigInfoWrapper.setTenant(targetTenant);
            this.updateConfigInfoAtomic(sourceConfigInfoWrapper, null, srcUser, null, targetConfigInfoWrapper.getLastModified(), targetConfigInfoWrapper.getMd5());
        }
    }

    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo, long lastModified, String targetMd5) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified@NOW()", "app_name", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id", "gmt_modified", "md5"));
        Object[] args = new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, appNameTmp, desc, use, effect, type, schema, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, new Timestamp(lastModified), targetMd5};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public void syncConfigGray(String dataId, String group, String tenant, String grayName, String targetTenant, String srcUser) {
        ConfigInfoGrayWrapper sourceConfigInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, grayName);
        ConfigInfoGrayWrapper targetConfigInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, targetTenant, grayName);
        if (sourceConfigInfoGrayWrapper == null) {
            this.removeConfigInfoGrayWithoutHistory(dataId, group, targetTenant, grayName, null, srcUser);
        } else if (targetConfigInfoGrayWrapper == null) {
            sourceConfigInfoGrayWrapper.setTenant(targetTenant);
            long configGrayId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_GRAY_ID);
            this.configInfoGrayPersistService.addConfigInfoGrayAtomic(configGrayId, sourceConfigInfoGrayWrapper, grayName, sourceConfigInfoGrayWrapper.getGrayRule(), null, srcUser);
        } else if (sourceConfigInfoGrayWrapper.getLastModified() >= targetConfigInfoGrayWrapper.getLastModified()) {
            sourceConfigInfoGrayWrapper.setTenant(targetTenant);
            this.updateConfigInfo4GrayWithoutHistory(sourceConfigInfoGrayWrapper, sourceConfigInfoGrayWrapper.getGrayName(), sourceConfigInfoGrayWrapper.getGrayRule(), null, srcUser, targetConfigInfoGrayWrapper.getLastModified(), targetConfigInfoGrayWrapper.getMd5());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigInfoGrayWithoutHistory(String dataId, String group, String tenant, String grayName, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName;
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "gray_name"));
        Object[] args = new Object[]{dataId, group, tenantTmp, grayNameTmp};
        EmbeddedStorageContextUtils.onDeleteConfigGrayInfo(tenantTmp, group, dataId, grayNameTmp, srcIp);
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigInfo4GrayWithoutHistory(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser, long lastModified, String targetMd5) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String sql = configInfoGrayMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified", "app_name", "gray_rule"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name", "gmt_modified", "md5"));
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, grayRuleTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp, new Timestamp(lastModified), targetMd5};
            EmbeddedStorageContextUtils.onModifyConfigGrayInfo(configInfo, grayNameTmp, grayRuleTmp, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }
}

