/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleaner;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryConfigCleaner
implements HistoryConfigCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHistoryConfigCleaner.class);
    private HistoryConfigInfoPersistService historyConfigInfoPersistService;

    @Override
    public void cleanHistoryConfig() {
        Timestamp startTime = this.getBeforeStamp(TimeUtils.getCurrentTime(), 24 * this.getRetentionDays());
        int pageSize = 1000;
        LOGGER.warn("clearConfigHistory, getBeforeStamp:{}, pageSize:{}", (Object)startTime, (Object)pageSize);
        this.getHistoryConfigInfoPersistService().removeConfigHistory(startTime, pageSize);
    }

    private HistoryConfigInfoPersistService getHistoryConfigInfoPersistService() {
        if (this.historyConfigInfoPersistService == null) {
            this.historyConfigInfoPersistService = (HistoryConfigInfoPersistService)ApplicationUtils.getBean(HistoryConfigInfoPersistService.class);
        }
        return this.historyConfigInfoPersistService;
    }

    private Timestamp getBeforeStamp(Timestamp date, int step) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, -step);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return Timestamp.valueOf(format.format(cal.getTime()));
    }

    private int getRetentionDays() {
        return PropertyUtil.getConfigRententionDays();
    }

    @Override
    public String getName() {
        return "nacos";
    }
}

