/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import com.alibaba.nacos.config.server.configuration.ConfigCommonConfig;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class ConfigFuzzyWatchContextService {
    private final Map<String, Set<String>> watchedClientsMap = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> matchedGroupKeysMap = new ConcurrentHashMap<String, Set<String>>();

    @PostConstruct
    public void init() {
        GlobalExecutor.scheduleWithFixDelayByCommon(() -> this.trimFuzzyWatchContext(), (long)30000L);
    }

    void trimFuzzyWatchContext() {
        try {
            Iterator<Map.Entry<String, Set<String>>> iterator = this.matchedGroupKeysMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Set<String>> matchedGroupKeys = iterator.next();
                Set<String> watchedClients = this.watchedClientsMap.get(matchedGroupKeys.getKey());
                if (watchedClients == null) {
                    iterator.remove();
                    LogUtil.DEFAULT_LOG.info("[fuzzy-watch] no watchedClients context for pattern {},remove matchedGroupKeys context", (Object)matchedGroupKeys.getKey());
                    continue;
                }
                if (watchedClients.isEmpty()) {
                    LogUtil.DEFAULT_LOG.info("[fuzzy-watch] no client watched pattern {},remove watchedClients context", (Object)matchedGroupKeys.getKey());
                    this.watchedClientsMap.remove(matchedGroupKeys.getKey());
                    continue;
                }
                if (this.reachToUpLimit(matchedGroupKeys.getValue().size())) {
                    LogUtil.DEFAULT_LOG.warn("[fuzzy-watch] pattern {} matched config count has reached to upper limit {}, fuzzy watch has been suppressed ", (Object)matchedGroupKeys.getKey(), (Object)matchedGroupKeys.getValue().size());
                    continue;
                }
                if (!this.reachToUpLimit((int)((double)matchedGroupKeys.getValue().size() * 1.25))) continue;
                LogUtil.DEFAULT_LOG.warn("[fuzzy-watch] pattern {} matched config count has reached to 80% of the upper limit {} ,it may has a risk of notify suppressed in the near further", (Object)matchedGroupKeys.getKey(), (Object)matchedGroupKeys.getValue().size());
            }
        }
        catch (Throwable throwable) {
            LogUtil.DEFAULT_LOG.warn("[fuzzy-watch] trim fuzzy watch context fail", throwable);
        }
    }

    public Set<String> matchGroupKeys(String groupKeyPattern) {
        Set<String> stringSet = this.matchedGroupKeysMap.get(groupKeyPattern);
        return stringSet == null ? new HashSet<String>() : new HashSet(this.matchedGroupKeysMap.get(groupKeyPattern));
    }

    public boolean syncGroupKeyContext(String groupKey, String changedType) {
        boolean needNotify = false;
        String[] groupKeyItems = GroupKey.parseKey(groupKey);
        String dataId = groupKeyItems[0];
        String group = groupKeyItems[1];
        String namespace = groupKeyItems[2];
        boolean tryAdd = changedType.equals("ADD_CONFIG") || changedType.equals("CONFIG_CHANGED");
        boolean tryRemove = changedType.equals("DELETE_CONFIG");
        for (Map.Entry<String, Set<String>> entry : this.matchedGroupKeysMap.entrySet()) {
            if (!FuzzyGroupKeyPattern.matchPattern((String)entry.getKey(), (String)dataId, (String)group, (String)namespace)) continue;
            boolean containsAlready = entry.getValue().contains(groupKey);
            boolean reachToUpLimit = this.reachToUpLimit(entry.getValue().size());
            if (tryAdd && !containsAlready && reachToUpLimit) {
                LogUtil.DEFAULT_LOG.warn("[fuzzy-watch] pattern matched config count is over limit , current config will be ignored for pattern {} ,current count is {}", (Object)entry.getKey(), (Object)entry.getValue().size());
                continue;
            }
            if (tryAdd && !containsAlready && entry.getValue().add(groupKey)) {
                needNotify = true;
            }
            if (!tryRemove || !containsAlready || !entry.getValue().remove(groupKey)) continue;
            needNotify = true;
            if (!reachToUpLimit) continue;
            this.makeupMatchedGroupKeys(entry.getKey());
        }
        return needNotify;
    }

    public void makeupMatchedGroupKeys(String groupKeyPattern) {
        Set<String> matchedGroupKeys = this.matchedGroupKeysMap.get(groupKeyPattern);
        if (matchedGroupKeys == null || this.reachToUpLimit(matchedGroupKeys.size())) {
            return;
        }
        for (String groupKey : ConfigCacheService.CACHE.keySet()) {
            String[] groupKeyItems = GroupKey.parseKey(groupKey);
            if (!FuzzyGroupKeyPattern.matchPattern((String)groupKeyPattern, (String)groupKeyItems[0], (String)groupKeyItems[1], (String)groupKeyItems[2]) || matchedGroupKeys.contains(groupKey)) continue;
            matchedGroupKeys.add(groupKey);
            LogUtil.DEFAULT_LOG.info("[fuzzy-watch] pattern {} makeup group key {}", (Object)groupKeyPattern, (Object)groupKey);
            if (!this.reachToUpLimit(matchedGroupKeys.size())) continue;
            LogUtil.DEFAULT_LOG.warn("[fuzzy-watch] pattern {] matched config count is over limit ,makeup group keys skip.", (Object)groupKeyPattern);
            return;
        }
    }

    private boolean reachToUpLimit(int size) {
        return size >= ConfigCommonConfig.getInstance().getMaxMatchedConfigCount();
    }

    public boolean reachToUpLimit(String groupKeyPattern) {
        Set<String> strings = this.matchedGroupKeysMap.get(groupKeyPattern);
        return strings != null && this.reachToUpLimit(strings.size());
    }

    private void initMatchGroupKeys(String groupKeyPattern) throws NacosException {
        if (this.matchedGroupKeysMap.containsKey(groupKeyPattern)) {
            return;
        }
        if (this.matchedGroupKeysMap.size() >= ConfigCommonConfig.getInstance().getMaxPatternCount()) {
            LogUtil.DEFAULT_LOG.warn("[fuzzy-watch] pattern count is over limit ,pattern {} init fail,current count is {}", (Object)groupKeyPattern, (Object)this.matchedGroupKeysMap.size());
            throw new NacosException(ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getCode().intValue(), ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getMsg());
        }
        this.matchedGroupKeysMap.computeIfAbsent(groupKeyPattern, k -> new HashSet());
        Set<String> matchedGroupKeys = this.matchedGroupKeysMap.get(groupKeyPattern);
        long matchBeginTime = System.currentTimeMillis();
        boolean overMatchCount = false;
        for (String groupKey : ConfigCacheService.CACHE.keySet()) {
            String[] groupKeyItems = GroupKey.parseKey(groupKey);
            if (!FuzzyGroupKeyPattern.matchPattern((String)groupKeyPattern, (String)groupKeyItems[0], (String)groupKeyItems[1], (String)groupKeyItems[2])) continue;
            if (this.reachToUpLimit(matchedGroupKeys.size())) {
                LogUtil.DEFAULT_LOG.warn("[fuzzy-watch]   pattern matched service count is over limit , other services will stop notify for pattern {} ,current count is {}", (Object)groupKeyPattern, (Object)matchedGroupKeys.size());
                overMatchCount = true;
                break;
            }
            matchedGroupKeys.add(groupKey);
        }
        LogUtil.DEFAULT_LOG.info("[fuzzy-watch]  pattern {} match {} group keys,overMatchCount={}, cost {}ms", new Object[]{groupKeyPattern, matchedGroupKeys.size(), overMatchCount, System.currentTimeMillis() - matchBeginTime});
    }

    public synchronized void addFuzzyWatch(String groupKeyPattern, String connectId) throws NacosException {
        this.watchedClientsMap.computeIfAbsent(groupKeyPattern, k -> new HashSet());
        this.initMatchGroupKeys(groupKeyPattern);
        this.watchedClientsMap.get(groupKeyPattern).add(connectId);
    }

    public synchronized void removeFuzzyListen(String groupKeyPattern, String connectionId) {
        Set<String> connectIds = this.watchedClientsMap.get(groupKeyPattern);
        if (CollectionUtils.isNotEmpty(connectIds)) {
            connectIds.remove(connectionId);
        }
    }

    public void clearFuzzyWatchContext(String connectionId) {
        for (Map.Entry<String, Set<String>> keyPatternContextEntry : this.watchedClientsMap.entrySet()) {
            Set<String> connectionIds = keyPatternContextEntry.getValue();
            if (!CollectionUtils.isNotEmpty(connectionIds)) continue;
            connectionIds.remove(connectionId);
        }
    }

    public Set<String> getMatchedClients(String groupKey) {
        HashSet<String> connectIds = new HashSet<String>();
        Iterator<Map.Entry<String, Set<String>>> watchClientIterator = this.watchedClientsMap.entrySet().iterator();
        String[] groupItems = GroupKey2.parseKey(groupKey);
        while (watchClientIterator.hasNext()) {
            Map.Entry<String, Set<String>> watchClientEntry = watchClientIterator.next();
            String keyPattern = watchClientEntry.getKey();
            if (!FuzzyGroupKeyPattern.matchPattern((String)keyPattern, (String)groupItems[0], (String)groupItems[1], (String)groupItems[2]) || !CollectionUtils.isNotEmpty((Collection)watchClientEntry.getValue())) continue;
            connectIds.addAll((Collection<String>)watchClientEntry.getValue());
        }
        return connectIds;
    }
}

