/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.model.ConfigCachePostProcessorDelegate;
import com.alibaba.nacos.config.server.model.event.LocalDataChangeEvent;
import com.alibaba.nacos.config.server.model.gray.GrayRule;
import com.alibaba.nacos.config.server.model.gray.GrayRuleManager;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigCacheService {
    private static final String NO_SPACE_CN = "\u8bbe\u5907\u4e0a\u6ca1\u6709\u7a7a\u95f4";
    private static final String NO_SPACE_EN = "No space left on device";
    private static final String DISK_QUOTA_CN = "\u8d85\u51fa\u78c1\u76d8\u9650\u989d";
    private static final String DISK_QUOTA_EN = "Disk quota exceeded";
    static final ConcurrentHashMap<String, CacheItem> CACHE = new ConcurrentHashMap();
    private static final int TRY_GET_LOCK_TIMES = 9;

    public static int groupCount() {
        return CACHE.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpWithMd5(String dataId, String group, String tenant, String content, String md5, long lastModifiedTs, String type, String encryptedDataKey) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        CacheItem ci = ConfigCacheService.makeSure(groupKey, encryptedDataKey);
        ci.setType(type);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            String localContentMd5;
            boolean md5Changed;
            boolean newLastModified;
            boolean lastModifiedOutDated;
            boolean bl = lastModifiedOutDated = lastModifiedTs < ConfigCacheService.getLastModifiedTs(groupKey);
            if (lastModifiedOutDated) {
                LogUtil.DUMP_LOG.warn("[dump-ignore] timestamp is outdated,groupKey={}", (Object)groupKey);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = newLastModified = lastModifiedTs > ConfigCacheService.getLastModifiedTs(groupKey);
            if (md5 == null) {
                md5 = MD5Utils.md5Hex((String)content, (String)Constants.PERSIST_ENCODE);
            }
            boolean bl4 = md5Changed = !md5.equals(localContentMd5 = ConfigCacheService.getContentMd5(groupKey));
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump] md5 changed, save to disk cache ,groupKey={}, newMd5={},oldMd5={}", new Object[]{groupKey, md5, localContentMd5});
                ConfigDiskServiceFactory.getInstance().saveToDisk(dataId, group, tenant, content);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-ignore] ignore to save to disk cache. md5 consistent,groupKey={}, md5={}", (Object)groupKey, (Object)md5);
            }
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump] md5 changed, update md5 and timestamp in jvm cache ,groupKey={}, newMd5={},oldMd5={},lastModifiedTs={}", new Object[]{groupKey, md5, localContentMd5, lastModifiedTs});
                ConfigCacheService.updateMd5(groupKey, md5, content, lastModifiedTs, encryptedDataKey);
            } else if (newLastModified) {
                LogUtil.DUMP_LOG.info("[dump] md5 consistent ,timestamp changed, update timestamp only in jvm cache ,groupKey={},lastModifiedTs={}", (Object)groupKey, (Object)lastModifiedTs);
                ConfigCacheService.updateTimeStamp(groupKey, lastModifiedTs, encryptedDataKey);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-ignore] ignore to save to jvm cache. md5 consistent and no new timestamp changed.groupKey={}", (Object)groupKey);
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (IOException ioe) {
            String errMsg;
            LogUtil.DUMP_LOG.error("[dump-exception] save disk error. " + groupKey + ", " + String.valueOf(ioe));
            if (ioe.getMessage() != null && ((errMsg = ioe.getMessage()).contains(NO_SPACE_CN) || errMsg.contains(NO_SPACE_EN) || errMsg.contains(DISK_QUOTA_CN) || errMsg.contains(DISK_QUOTA_EN))) {
                LogUtil.FATAL_LOG.error("Local Disk Full,Exit", (Throwable)ioe);
                EnvUtil.systemExit();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    public static boolean dump(String dataId, String group, String tenant, String content, long lastModifiedTs, String type, String encryptedDataKey) {
        return ConfigCacheService.dumpWithMd5(dataId, group, tenant, content, null, lastModifiedTs, type, encryptedDataKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpGray(String dataId, String group, String tenant, String grayName, String grayRule, String content, long lastModifiedTs, String encryptedDataKey) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        ConfigCacheService.makeSure(groupKey, null);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-gray-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            boolean grayRuleChanged;
            boolean timestampOutdated;
            long localGrayLastModifiedTs = ConfigCacheService.getGrayLastModifiedTs(groupKey, grayName);
            boolean bl = timestampOutdated = lastModifiedTs < localGrayLastModifiedTs;
            if (timestampOutdated) {
                LogUtil.DUMP_LOG.warn("[dump-gray-ignore] timestamp is outdated,groupKey={}", (Object)groupKey);
                boolean bl2 = true;
                return bl2;
            }
            boolean timestampChanged = lastModifiedTs > localGrayLastModifiedTs;
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            String localContentGrayMd5 = ConfigCacheService.getContentGrayMd5(groupKey, grayName);
            boolean md5Changed = !md5.equals(localContentGrayMd5);
            GrayRule localGrayRule = ConfigCacheService.getGrayRule(groupKey, grayName);
            GrayRule grayRuleNew = GrayRuleManager.constructGrayRule(GrayRuleManager.deserializeConfigGrayPersistInfo(grayRule));
            if (grayRuleNew == null) {
                LogUtil.DUMP_LOG.warn("[dump-gray-exception] . " + groupKey + ",  unknown gray rule for  gray name" + grayName);
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = grayRuleChanged = !grayRuleNew.equals(localGrayRule);
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump-gray] md5 changed, update local jvm cache& local disk cache, groupKey={},grayName={}, newMd5={},oldMd5={}, newGrayRule={}, oldGrayRule={},lastModifiedTs={}", new Object[]{groupKey, grayName, md5, localContentGrayMd5, grayRule, localGrayRule, lastModifiedTs});
                ConfigCacheService.updateGrayMd5(groupKey, grayName, grayRule, md5, content, lastModifiedTs, encryptedDataKey);
                ConfigDiskServiceFactory.getInstance().saveGrayToDisk(dataId, group, tenant, grayName, content);
            } else if (grayRuleChanged) {
                LogUtil.DUMP_LOG.info("[dump-gray] gray rule changed, update local jvm cache, groupKey={},grayName={}, newMd5={},oldMd5={}, newGrayRule={}, oldGrayRule={},lastModifiedTs={}", new Object[]{groupKey, grayName, md5, localContentGrayMd5, grayRule, localGrayRule, lastModifiedTs});
                ConfigCacheService.updateGrayRule(groupKey, grayName, grayRule, lastModifiedTs, encryptedDataKey);
            } else if (timestampChanged) {
                LogUtil.DUMP_LOG.info("[dump-gray] timestamp changed, update last modified in local jvm cache, groupKey={},grayName={},grayLastModifiedTs={},oldgrayLastModifiedTs={}", new Object[]{groupKey, grayName, lastModifiedTs, localGrayLastModifiedTs});
                ConfigCacheService.updateGrayTimeStamp(groupKey, grayName, lastModifiedTs);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-gray-ignore] md5 & timestamp not changed. groupKey={},grayName={}", (Object)groupKey, (Object)grayName);
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (IOException ioe) {
            LogUtil.DUMP_LOG.error("[dump-gray-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeGray(String dataId, String group, String tenant, String grayName) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            LogUtil.DUMP_LOG.info("[remove-gray-ok] remove gray in local disk cache,grayName={},groupKey={} ", (Object)grayName, (Object)groupKey);
            ConfigDiskServiceFactory.getInstance().removeConfigInfo4Gray(dataId, group, tenant, grayName);
            CacheItem ci = CACHE.get(groupKey);
            if (ci.getConfigCacheGray() != null) {
                ci.getConfigCacheGray().remove(grayName);
                if (ci.getConfigCacheGray().isEmpty()) {
                    ci.clearConfigGrays();
                } else {
                    ci.sortConfigGray();
                }
            }
            LogUtil.DUMP_LOG.info("[remove-gray-ok] remove gray in local jvm cache,grayName={},groupKey={} ", (Object)grayName, (Object)groupKey);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(String dataId, String group, String tenant) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            LogUtil.DUMP_LOG.info("[dump] remove  local disk cache,groupKey={} ", (Object)groupKey);
            ConfigDiskServiceFactory.getInstance().removeConfigInfo(dataId, group, tenant);
            CACHE.remove(groupKey);
            LogUtil.DUMP_LOG.info("[dump] remove  local jvm cache,groupKey={} ", (Object)groupKey);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    public static void updateMd5(String groupKey, String md5, String content, long lastModifiedTs, String encryptedDataKey) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, encryptedDataKey);
        ConfigCache configCache = cache.getConfigCache();
        if (configCache.getMd5() == null || !configCache.getMd5().equals(md5)) {
            configCache.setMd5(md5);
            configCache.setLastModifiedTs(lastModifiedTs);
            configCache.setEncryptedDataKey(encryptedDataKey);
            ConfigCachePostProcessorDelegate.getInstance().postProcess(configCache, content);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
        }
    }

    public static void updateGrayMd5(String groupKey, String grayName, String grayRule, String md5, String content, long lastModifiedTs, String encryptedDataKey) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initConfigGrayIfEmpty(grayName);
        ConfigCacheGray configCache = cache.getConfigCacheGray().get(grayName);
        configCache.setMd5(md5);
        configCache.setLastModifiedTs(lastModifiedTs);
        configCache.setEncryptedDataKey(encryptedDataKey);
        configCache.resetGrayRule(grayRule);
        cache.sortConfigGray();
        ConfigCachePostProcessorDelegate.getInstance().postProcess(configCache, content);
        NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
    }

    public static String getContentMd5(String groupKey) {
        return ConfigCacheService.getContentMd5(groupKey, null, null);
    }

    public static String getContentMd5(String groupKey, String ip, String tag) {
        return ConfigCacheService.getContentMd5(groupKey, ip, tag, null);
    }

    public static String getContentMd5(String groupKey, String ip, String tag, Map<String, String> connLabels) {
        String md5;
        CacheItem item = CACHE.get(groupKey);
        if (item == null) {
            return "";
        }
        if (connLabels == null && StringUtils.isNotBlank((String)ip)) {
            connLabels = new HashMap<String, String>(4);
        }
        if (connLabels == null && StringUtils.isNotBlank((String)tag)) {
            connLabels = new HashMap<String, String>(4);
        }
        if (StringUtils.isNotBlank((String)ip)) {
            connLabels.put("ClientIp", ip);
        }
        if (StringUtils.isNotBlank((String)tag)) {
            connLabels.put("Vipserver-Tag", tag);
        }
        if (item.getSortConfigGrays() != null && connLabels != null && !connLabels.isEmpty()) {
            for (ConfigCacheGray entry : item.getSortConfigGrays()) {
                if (!entry.match(connLabels)) continue;
                return entry.getMd5();
            }
        }
        return (md5 = item.getConfigCache().getMd5()) == null ? "" : md5;
    }

    private static void updateGrayRule(String groupKey, String grayName, String grayRule, long lastModifiedTs, String encryptedDataKey) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initConfigGrayIfEmpty(grayName);
        ConfigCacheGray configCache = cache.getConfigCacheGray().get(grayName);
        configCache.setLastModifiedTs(lastModifiedTs);
        configCache.setEncryptedDataKey(encryptedDataKey);
        configCache.resetGrayRule(grayRule);
        cache.sortConfigGray();
        NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
    }

    public static String getContentGrayMd5(String groupKey, String grayName) {
        CacheItem item = CACHE.get(groupKey);
        if (item == null || item.getConfigCacheGray() == null || !item.getConfigCacheGray().containsKey(grayName)) {
            return "";
        }
        return item.getConfigCacheGray().get(grayName).getMd5();
    }

    public static long getGrayLastModifiedTs(String groupKey, String grayName) {
        CacheItem item = CACHE.get(groupKey);
        if (item.getConfigCacheGray() == null || !item.getConfigCacheGray().containsKey(grayName)) {
            return 0L;
        }
        ConfigCache configCacheGray = item.getConfigCacheGray().get(grayName);
        return null != configCacheGray ? configCacheGray.getLastModifiedTs() : 0L;
    }

    public static GrayRule getGrayRule(String groupKey, String grayName) {
        CacheItem item = CACHE.get(groupKey);
        if (item == null || item.getConfigCacheGray() == null || !item.getConfigCacheGray().containsKey(grayName)) {
            return null;
        }
        return item.getConfigCacheGray().get(grayName).getGrayRule();
    }

    public static CacheItem getContentCache(String groupKey) {
        return CACHE.get(groupKey);
    }

    public static long getLastModifiedTs(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.getConfigCache().getLastModifiedTs() : 0L;
    }

    private static void updateGrayTimeStamp(String groupKey, String grayName, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initConfigGrayIfEmpty(grayName);
        cache.getConfigCacheGray().get(grayName).setLastModifiedTs(lastModifiedTs);
    }

    public static boolean isUptodate(String groupKey, String md5) {
        return ConfigCacheService.isUptodate(groupKey, md5, null, null);
    }

    public static boolean isUptodate(String groupKey, String md5, String ip, String tag) {
        return ConfigCacheService.isUptodate(groupKey, md5, ip, tag, null);
    }

    public static boolean isUptodate(String groupKey, String md5, String ip, String tag, Map<String, String> appLabels) {
        String serverMd5 = ConfigCacheService.getContentMd5(groupKey, ip, tag, appLabels);
        return StringUtils.equals((String)md5, (String)serverMd5);
    }

    public static int tryReadLock(String groupKey) {
        int result;
        CacheItem groupItem = CACHE.get(groupKey);
        int n = null == groupItem ? 0 : (result = groupItem.getRwLock().tryReadLock() ? 1 : -1);
        if (result < 0) {
            LogUtil.DEFAULT_LOG.warn("[read-lock] failed, {}, {}", (Object)result, (Object)groupKey);
        }
        return result;
    }

    public static void releaseReadLock(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        if (null != item) {
            item.getRwLock().releaseReadLock();
        }
    }

    static int tryWriteLock(String groupKey) {
        int result;
        CacheItem groupItem = CACHE.get(groupKey);
        int n = null == groupItem ? 0 : (result = groupItem.getRwLock().tryWriteLock() ? 1 : -1);
        if (result < 0) {
            LogUtil.DEFAULT_LOG.warn("[write-lock] failed, {}, {}", (Object)result, (Object)groupKey);
        }
        return result;
    }

    static void releaseWriteLock(String groupKey) {
        CacheItem groupItem = CACHE.get(groupKey);
        if (null != groupItem) {
            groupItem.getRwLock().releaseWriteLock();
        }
    }

    static CacheItem makeSure(String groupKey, String encryptedDataKey) {
        CacheItem item = CACHE.get(groupKey);
        if (null != item) {
            return item;
        }
        CacheItem tmp = new CacheItem(groupKey, encryptedDataKey);
        item = CACHE.putIfAbsent(groupKey, tmp);
        return null == item ? tmp : item;
    }

    private static void updateTimeStamp(String groupKey, long lastModifiedTs, String encryptedDataKey) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, encryptedDataKey);
        cache.getConfigCache().setLastModifiedTs(lastModifiedTs);
    }

    public static int tryConfigReadLock(String groupKey) {
        int lockResult = -1;
        for (int i = 9; i >= 0 && 0 != (lockResult = ConfigCacheService.tryReadLock(groupKey)) && lockResult <= 0; --i) {
            if (i <= 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                LogUtil.PULL_CHECK_LOG.error("An Exception occurred while thread sleep", (Throwable)e);
            }
        }
        return lockResult;
    }
}

