/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchSyncRequest;
import com.alibaba.nacos.api.remote.AbstractPushCallBack;
import com.alibaba.nacos.config.server.remote.FuzzyWatchSyncNotifyTask;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;

class FuzzyWatchSyncNotifyCallback
extends AbstractPushCallBack {
    FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask;

    public FuzzyWatchSyncNotifyCallback(FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask) {
        super(3000L);
        this.fuzzyWatchSyncNotifyTask = fuzzyWatchSyncNotifyTask;
    }

    public void onSuccess() {
        TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
        tpsCheckRequest.setPointName("CONFIG_FUZZY_WATCH_CONFIG_SYNC_SUCCESS");
        ControlManagerCenter.getInstance().getTpsControlManager().check(tpsCheckRequest);
        if (this.fuzzyWatchSyncNotifyTask.batchTaskCounter != null) {
            this.fuzzyWatchSyncNotifyTask.batchTaskCounter.batchSuccess(this.fuzzyWatchSyncNotifyTask.notifyRequest.getCurrentBatch());
            if (this.fuzzyWatchSyncNotifyTask.batchTaskCounter.batchCompleted() && this.fuzzyWatchSyncNotifyTask.notifyRequest.getSyncType().equals("FUZZY_WATCH_INIT_NOTIFY")) {
                ConfigFuzzyWatchSyncRequest request = ConfigFuzzyWatchSyncRequest.buildInitFinishRequest((String)this.fuzzyWatchSyncNotifyTask.notifyRequest.getGroupKeyPattern());
                FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTaskFinish = new FuzzyWatchSyncNotifyTask(this.fuzzyWatchSyncNotifyTask.connectionManager, this.fuzzyWatchSyncNotifyTask.rpcPushService, request, null, this.fuzzyWatchSyncNotifyTask.maxRetryTimes, this.fuzzyWatchSyncNotifyTask.connectionId);
                fuzzyWatchSyncNotifyTaskFinish.scheduleSelf();
            }
        }
    }

    public void onFail(Throwable e) {
        TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
        tpsCheckRequest.setPointName("CONFIG_FUZZY_WATCH_CONFIG_SYNC_FAIL");
        ControlManagerCenter.getInstance().getTpsControlManager().check(tpsCheckRequest);
        Loggers.REMOTE_PUSH.warn("Push fail, groupKeyPattern={}, clientId={}", new Object[]{this.fuzzyWatchSyncNotifyTask.notifyRequest.getGroupKeyPattern(), this.fuzzyWatchSyncNotifyTask.connectionId, e});
        this.fuzzyWatchSyncNotifyTask.scheduleSelf();
    }
}

