/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model.gray;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.config.server.model.gray.AbstractGrayRule;
import java.util.Map;
import java.util.Objects;

public class TagGrayRule
extends AbstractGrayRule {
    String tagValue;
    public static final String VIP_SERVER_TAG_LABEL = "Vipserver-Tag";
    public static final String TYPE_TAG = "tag";
    public static final String VERSION = "1.0.0";
    public static final int PRIORITY = 0x7FFFFFFE;

    public TagGrayRule() {
    }

    public TagGrayRule(String rawGrayRuleExp, int priority) {
        super(rawGrayRuleExp, priority);
    }

    @Override
    protected void parse(String rawGrayRule) throws NacosException {
        if (StringUtils.isBlank((CharSequence)rawGrayRule)) {
            return;
        }
        this.tagValue = rawGrayRule;
    }

    @Override
    public boolean match(Map<String, String> labels) {
        return labels.containsKey(VIP_SERVER_TAG_LABEL) && this.tagValue.equals(labels.get(VIP_SERVER_TAG_LABEL));
    }

    @Override
    public String getType() {
        return TYPE_TAG;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagGrayRule that = (TagGrayRule)o;
        return this.tagValue.equals(that.tagValue);
    }

    public int hashCode() {
        return Objects.hash(this.tagValue);
    }
}

