/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model.gray;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.config.server.model.gray.AbstractGrayRule;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BetaGrayRule
extends AbstractGrayRule {
    Set<String> betaIps;
    public static final String CLIENT_IP_LABEL = "ClientIp";
    public static final String TYPE_BETA = "beta";
    public static final String VERSION = "1.0.0";
    public static final int PRIORITY = Integer.MAX_VALUE;

    public BetaGrayRule() {
    }

    public BetaGrayRule(String betaIps, int priority) {
        super(betaIps, priority);
    }

    @Override
    protected void parse(String rawGrayRule) throws NacosException {
        String[] ips;
        HashSet<String> betaIps = new HashSet<String>();
        for (String ip : ips = rawGrayRule.split(",")) {
            betaIps.add(ip);
        }
        this.betaIps = betaIps;
    }

    @Override
    public boolean match(Map<String, String> labels) {
        return labels.containsKey(CLIENT_IP_LABEL) && this.betaIps.contains(labels.get(CLIENT_IP_LABEL));
    }

    @Override
    public String getType() {
        return TYPE_BETA;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetaGrayRule that = (BetaGrayRule)o;
        return Objects.equals(this.betaIps, that.betaIps);
    }

    public int hashCode() {
        return Objects.hash(this.betaIps);
    }
}

