/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.serveridentity;

import com.alibaba.nacos.auth.serveridentity.DefaultChecker;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityChecker;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIdentityCheckerHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerIdentityCheckerHolder.class);
    private static final ServerIdentityCheckerHolder INSTANCE = new ServerIdentityCheckerHolder();
    private Class<? extends ServerIdentityChecker> checkerClass;

    private ServerIdentityCheckerHolder() {
        this.tryGetCheckerBySpi();
    }

    public static ServerIdentityCheckerHolder getInstance() {
        return INSTANCE;
    }

    public ServerIdentityChecker newChecker() {
        try {
            return this.checkerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new DefaultChecker();
        }
    }

    private synchronized void tryGetCheckerBySpi() {
        Collection checkers = NacosServiceLoader.load(ServerIdentityChecker.class);
        if (checkers.isEmpty()) {
            this.checkerClass = DefaultChecker.class;
            LOGGER.info("Not found ServerIdentityChecker implementation from SPI, use default.");
            return;
        }
        if (checkers.size() > 1) {
            this.checkerClass = this.showAllImplementations(checkers);
            return;
        }
        this.checkerClass = ((ServerIdentityChecker)checkers.iterator().next()).getClass();
        LOGGER.info("Found ServerIdentityChecker implementation {}", (Object)this.checkerClass.getClass().getCanonicalName());
    }

    private Class<? extends ServerIdentityChecker> showAllImplementations(Collection<ServerIdentityChecker> checkers) {
        ServerIdentityChecker result = checkers.iterator().next();
        for (ServerIdentityChecker each : checkers) {
            LOGGER.warn("Found ServerIdentityChecker implementation {}", (Object)each.getClass().getCanonicalName());
        }
        LOGGER.warn("Found more than one ServerIdentityChecker implementation from SPI, use the first one {}.", (Object)result.getClass().getCanonicalName());
        return result.getClass();
    }
}

