/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.utils;

import com.alibaba.nacos.ai.form.mcp.admin.McpDetailForm;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpRequestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpRequestUtil.class);

    public static McpServerBasicInfo parseMcpServerBasicInfo(McpDetailForm mcpForm) throws NacosApiException {
        McpServerBasicInfo result = McpRequestUtil.deserializeSpec(mcpForm.getServerSpecification(), new TypeReference<McpServerBasicInfo>(){});
        if (StringUtils.isEmpty((String)result.getName())) {
            result.setName(mcpForm.getMcpName());
        }
        return result;
    }

    public static McpToolSpecification parseMcpTools(McpDetailForm mcpForm) throws NacosApiException {
        if (StringUtils.isBlank((CharSequence)mcpForm.getToolSpecification())) {
            return null;
        }
        return McpRequestUtil.deserializeSpec(mcpForm.getToolSpecification(), new TypeReference<McpToolSpecification>(){});
    }

    public static McpEndpointSpec parseMcpEndpointSpec(McpServerBasicInfo basicInfo, McpDetailForm mcpForm) throws NacosApiException {
        if ("stdio".equalsIgnoreCase(basicInfo.getProtocol())) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)mcpForm.getEndpointSpecification())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "request parameter `endpointSpecification` is required if mcp server type not `local`.");
        }
        return McpRequestUtil.deserializeSpec(mcpForm.getEndpointSpecification(), new TypeReference<McpEndpointSpec>(){});
    }

    public static <T> T deserializeSpec(String spec, TypeReference<T> typeReference) throws NacosApiException {
        return McpRequestUtil.deserializeSpec(spec, typeReference, LOGGER);
    }

    public static <T> T deserializeSpec(String spec, TypeReference<T> typeReference, Logger logger) throws NacosApiException {
        try {
            return (T)JacksonUtils.toObj((String)spec, typeReference);
        }
        catch (NacosDeserializationException e) {
            logger.error(String.format("Deserialize %s from %s failed, ", typeReference.getType().getTypeName(), spec), (Throwable)e);
            throw new NacosApiException(400, ErrorCode.PARAMETER_VALIDATE_ERROR, "serverSpecification or toolSpecification is invalid. Can't be parsed.");
        }
    }
}

