/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.ai.model.mcp.McpServerStorageInfo;
import com.alibaba.nacos.ai.service.McpEndpointOperationService;
import com.alibaba.nacos.ai.service.McpToolOperationService;
import com.alibaba.nacos.ai.utils.McpConfigUtils;
import com.alibaba.nacos.ai.utils.McpProtocolUtils;
import com.alibaba.nacos.api.ai.model.mcp.McpCapability;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerVersionInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.ai.model.mcp.registry.ServerVersionDetail;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

@org.springframework.stereotype.Service
public class McpServerOperationService {
    private final ConfigQueryChainService configQueryChainService;
    private final ConfigOperationService configOperationService;
    private final McpToolOperationService toolOperationService;
    private final McpEndpointOperationService endpointOperationService;
    private final McpServerIndex mcpServerIndex;

    public McpServerOperationService(ConfigQueryChainService configQueryChainService, ConfigOperationService configOperationService, McpToolOperationService toolOperationService, McpEndpointOperationService endpointOperationService, McpServerIndex mcpServerIndex) {
        this.configQueryChainService = configQueryChainService;
        this.configOperationService = configOperationService;
        this.toolOperationService = toolOperationService;
        this.endpointOperationService = endpointOperationService;
        this.mcpServerIndex = mcpServerIndex;
    }

    public Page<McpServerBasicInfo> listMcpServerWithPage(String namespaceId, String mcpName, String search, int pageNo, int pageSize) {
        int offset = pageSize * (pageNo - 1);
        Page<McpServerIndexData> indexData = this.mcpServerIndex.searchMcpServerByName(namespaceId, mcpName, search, offset, pageSize);
        return this.mapIndexToBasicServerInfo(indexData);
    }

    private Page<McpServerBasicInfo> mapIndexToBasicServerInfo(Page<McpServerIndexData> indexData) {
        Page result = new Page();
        result.setTotalCount(indexData.getTotalCount());
        result.setPageNumber(indexData.getPageNumber());
        result.setPagesAvailable(indexData.getPagesAvailable());
        List finalResult = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)indexData.getPageItems())) {
            finalResult = indexData.getPageItems().stream().map(index -> this.buildQueryMcpServerVersionInfoRequest(index.getNamespaceId(), index.getId())).map(arg_0 -> ((ConfigQueryChainService)this.configQueryChainService).handle(arg_0)).map(ConfigQueryChainResponse::getContent).map(this::transferToMcpServerVersionInfo).collect(Collectors.toList());
        }
        result.setPageItems(finalResult);
        return result;
    }

    public Page<McpServerBasicInfo> listMcpServerWithOffset(String namespaceId, String mcpName, String search, int offset, int limit) {
        Page<McpServerIndexData> indexData = this.mcpServerIndex.searchMcpServerByName(namespaceId, mcpName, search, offset, limit);
        return this.mapIndexToBasicServerInfo(indexData);
    }

    public McpServerDetailInfo getMcpServerDetail(String namespaceId, String mcpServerId, String mcpServerName, String version) throws NacosException {
        ConfigQueryChainRequest request;
        ConfigQueryChainResponse response;
        mcpServerId = this.resolveMcpServerId(namespaceId, mcpServerName, mcpServerId);
        McpServerVersionInfo mcpServerVersionInfo = this.getMcpServerVersionInfo(namespaceId, mcpServerId);
        if (StringUtils.isEmpty((String)version)) {
            int size = mcpServerVersionInfo.getVersionDetails().size();
            ServerVersionDetail last = (ServerVersionDetail)mcpServerVersionInfo.getVersionDetails().get(size - 1);
            version = last.getVersion();
        }
        if (McpConfigUtils.isConfigNotFound((response = this.configQueryChainService.handle(request = this.buildQueryMcpServerRequest(namespaceId, mcpServerId, version))).getStatus())) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, String.format("mcp server `%s` for version `%s` not found", mcpServerId, version));
        }
        McpServerStorageInfo serverSpecification = (McpServerStorageInfo)((Object)JacksonUtils.toObj((String)response.getContent(), McpServerStorageInfo.class));
        McpServerDetailInfo result = new McpServerDetailInfo();
        result.setId(mcpServerId);
        result.setNamespaceId(namespaceId);
        BeanUtils.copyProperties((Object)((Object)serverSpecification), (Object)result);
        List versionDetails = mcpServerVersionInfo.getVersionDetails();
        String latestVersion = mcpServerVersionInfo.getLatestPublishedVersion();
        for (ServerVersionDetail versionDetail : versionDetails) {
            versionDetail.setIs_latest(Boolean.valueOf(versionDetail.getVersion().equals(latestVersion)));
        }
        result.setAllVersions(mcpServerVersionInfo.getVersionDetails());
        ServerVersionDetail versionDetail = result.getVersionDetail();
        versionDetail.setIs_latest(Boolean.valueOf(versionDetail.getVersion().equals(latestVersion)));
        result.setVersion(versionDetail.getVersion());
        if (Objects.nonNull(serverSpecification.getToolsDescriptionRef())) {
            McpToolSpecification toolSpec = this.toolOperationService.getMcpTool(namespaceId, serverSpecification.getToolsDescriptionRef());
            result.setToolSpec(toolSpec);
        }
        if (!"stdio".equalsIgnoreCase(serverSpecification.getProtocol())) {
            this.injectBackendEndpointRef(namespaceId, result);
        }
        return result;
    }

    private McpServerVersionInfo getMcpServerVersionInfo(String namespaceId, String mcpServerId) throws NacosApiException {
        ConfigQueryChainRequest request = this.buildQueryMcpServerVersionInfoRequest(namespaceId, mcpServerId);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (McpConfigUtils.isConfigNotFound(response.getStatus())) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, String.format("mcp server `%s` not found", mcpServerId));
        }
        return (McpServerVersionInfo)JacksonUtils.toObj((String)response.getContent(), McpServerVersionInfo.class);
    }

    private void injectBackendEndpointRef(String namespaceId, McpServerDetailInfo detailInfo) throws NacosException {
        List<Instance> instances;
        if (McpProtocolUtils.isProtocolNeedTranslator(detailInfo.getProtocol())) {
            McpServiceRef mcpServiceRef = new McpServiceRef();
            mcpServiceRef.setServiceName(detailInfo.getName());
            mcpServiceRef.setGroupName("mcp-protocol-translator");
            mcpServiceRef.setNamespaceId(namespaceId);
            instances = this.endpointOperationService.getMcpServerEndpointInstances(mcpServiceRef);
        } else {
            instances = this.endpointOperationService.getMcpServerEndpointInstances(detailInfo.getRemoteServerConfig().getServiceRef());
        }
        LinkedList<McpEndpointInfo> backendEndpoints = new LinkedList<McpEndpointInfo>();
        for (Instance each : instances) {
            McpEndpointInfo mcpEndpointInfo = new McpEndpointInfo();
            mcpEndpointInfo.setAddress(each.getIp());
            mcpEndpointInfo.setPort(each.getPort());
            String exportPath = detailInfo.getRemoteServerConfig().getExportPath();
            if ("http".equals(detailInfo.getProtocol())) {
                exportPath = (String)each.getMetadata().get("path");
            }
            mcpEndpointInfo.setPath(exportPath);
            backendEndpoints.add(mcpEndpointInfo);
        }
        detailInfo.setBackendEndpoints(backendEndpoints);
    }

    public String createMcpServer(String namespaceId, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        String existId = this.resolveMcpServerId(namespaceId, serverSpecification.getName(), "");
        if (StringUtils.isNotEmpty((String)existId)) {
            throw new NacosApiException(409, ErrorCode.RESOURCE_CONFLICT, String.format("mcp server `%s` has existed, please update it rather than create.", serverSpecification.getName()));
        }
        ServerVersionDetail versionDetail = serverSpecification.getVersionDetail();
        if (null == versionDetail && StringUtils.isNotBlank((String)serverSpecification.getVersion())) {
            versionDetail = new ServerVersionDetail();
            versionDetail.setVersion(serverSpecification.getVersion());
            serverSpecification.setVersionDetail(versionDetail);
        }
        if (Objects.isNull(versionDetail) || StringUtils.isEmpty((String)versionDetail.getVersion())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_VALIDATE_ERROR, "Version must be specified in parameter `serverSpecification`");
        }
        String id = UUID.randomUUID().toString();
        serverSpecification.setId(id);
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String formattedCurrentTime = currentTime.format(formatter);
        versionDetail.setRelease_date(formattedCurrentTime);
        McpServerStorageInfo newSpecification = new McpServerStorageInfo();
        BeanUtils.copyProperties((Object)serverSpecification, (Object)((Object)newSpecification));
        this.injectToolAndEndpoint(namespaceId, serverSpecification.getId(), newSpecification, toolSpecification, endpointSpecification);
        McpServerVersionInfo versionInfo = McpServerOperationService.buildServerVersionInfo(newSpecification, id, versionDetail);
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setUpdateForExist(Boolean.FALSE);
        ConfigFormV3 mcpServerVersionForm = this.buildMcpServerVersionForm(namespaceId, versionInfo);
        this.configOperationService.publishConfig((ConfigForm)mcpServerVersionForm, configRequestInfo, null);
        ConfigFormV3 configForm = this.buildMcpConfigForm(namespaceId, id, versionDetail.getVersion(), newSpecification);
        this.configOperationService.publishConfig((ConfigForm)configForm, configRequestInfo, null);
        return id;
    }

    private static McpServerVersionInfo buildServerVersionInfo(McpServerBasicInfo serverSpecification, String id, ServerVersionDetail versionDetail) {
        McpServerVersionInfo versionInfo = new McpServerVersionInfo();
        versionInfo.setName(serverSpecification.getName());
        versionInfo.setId(id);
        versionInfo.setDescription(serverSpecification.getDescription());
        versionInfo.setRepository(serverSpecification.getRepository());
        versionInfo.setFrontProtocol(serverSpecification.getFrontProtocol());
        versionInfo.setProtocol(serverSpecification.getProtocol());
        versionInfo.setCapabilities(serverSpecification.getCapabilities());
        versionInfo.setLatestPublishedVersion(serverSpecification.getVersionDetail().getVersion());
        versionInfo.setVersions(Collections.singletonList(versionDetail));
        return versionInfo;
    }

    public void updateMcpServer(String namespaceId, boolean isPublish, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        ServerVersionDetail versionDetail;
        String mcpServerId = serverSpecification.getId();
        mcpServerId = this.resolveMcpServerId(namespaceId, serverSpecification.getName(), mcpServerId);
        if (StringUtils.isEmpty((String)serverSpecification.getId())) {
            serverSpecification.setId(mcpServerId);
        }
        if (null == (versionDetail = serverSpecification.getVersionDetail()) && StringUtils.isNotBlank((String)serverSpecification.getVersion())) {
            versionDetail = new ServerVersionDetail();
            versionDetail.setVersion(serverSpecification.getVersion());
            serverSpecification.setVersionDetail(versionDetail);
        }
        if (Objects.isNull(versionDetail) || StringUtils.isEmpty((String)versionDetail.getVersion())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_VALIDATE_ERROR, "Version must be specified in parameter `serverSpecification`");
        }
        McpServerVersionInfo mcpServerVersionInfo = this.getMcpServerVersionInfo(namespaceId, mcpServerId);
        String updateVersion = versionDetail.getVersion();
        McpServerStorageInfo newSpecification = new McpServerStorageInfo();
        BeanUtils.copyProperties((Object)serverSpecification, (Object)((Object)newSpecification));
        this.injectToolAndEndpoint(namespaceId, mcpServerId, newSpecification, toolSpecification, endpointSpecification);
        ConfigFormV3 configForm = this.buildMcpConfigForm(namespaceId, mcpServerId, updateVersion, newSpecification);
        this.configOperationService.publishConfig((ConfigForm)configForm, new ConfigRequestInfo(), null);
        List versionDetails = mcpServerVersionInfo.getVersionDetails();
        Set versionSet = versionDetails.stream().map(ServerVersionDetail::getVersion).collect(Collectors.toSet());
        if (!versionSet.contains(updateVersion)) {
            ServerVersionDetail version = new ServerVersionDetail();
            version.setVersion(updateVersion);
            versionDetails.add(version);
            mcpServerVersionInfo.setVersions(versionDetails);
        }
        if (isPublish) {
            mcpServerVersionInfo.setName(newSpecification.getName());
            mcpServerVersionInfo.setDescription(newSpecification.getDescription());
            mcpServerVersionInfo.setRepository(newSpecification.getRepository());
            mcpServerVersionInfo.setProtocol(newSpecification.getProtocol());
            mcpServerVersionInfo.setFrontProtocol(newSpecification.getFrontProtocol());
            mcpServerVersionInfo.setCapabilities(newSpecification.getCapabilities());
            mcpServerVersionInfo.setLatestPublishedVersion(updateVersion);
            for (ServerVersionDetail detail : versionDetails) {
                if (detail.getVersion().equals(updateVersion)) {
                    ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    String formattedCurrentTime = currentTime.format(formatter);
                    detail.setRelease_date(formattedCurrentTime);
                    detail.setIs_latest(Boolean.valueOf(true));
                    break;
                }
                detail.setIs_latest(Boolean.valueOf(false));
            }
            mcpServerVersionInfo.setVersions(versionDetails);
        }
        ConfigFormV3 mcpServerVersionForm = this.buildMcpServerVersionForm(namespaceId, mcpServerVersionInfo);
        this.configOperationService.publishConfig((ConfigForm)mcpServerVersionForm, new ConfigRequestInfo(), null);
    }

    public void deleteMcpServer(String namespaceId, String mcpName, String mcpServerId, String version) throws NacosException {
        mcpServerId = this.resolveMcpServerId(namespaceId, mcpName, mcpServerId);
        McpServerVersionInfo mcpServerVersionInfo = this.getMcpServerVersionInfo(namespaceId, mcpServerId);
        List<String> versionsNeedDelete = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)version)) {
            versionsNeedDelete.add(version);
        } else {
            versionsNeedDelete = mcpServerVersionInfo.getVersionDetails().stream().map(ServerVersionDetail::getVersion).collect(Collectors.toList());
        }
        for (String versionNeedDelete : versionsNeedDelete) {
            this.toolOperationService.deleteMcpTool(namespaceId, mcpServerId, versionNeedDelete);
            this.endpointOperationService.deleteMcpServerEndpointService(namespaceId, mcpServerVersionInfo.getName());
            String serverSpecDataId = McpConfigUtils.formatServerSpecInfoDataId(mcpServerId, versionNeedDelete);
            this.configOperationService.deleteConfig(serverSpecDataId, "mcp-server", namespaceId, null, null, "nacos", null);
            String serverVersionDataId = McpConfigUtils.formatServerVersionInfoDataId(mcpServerId);
            this.configOperationService.deleteConfig(serverVersionDataId, "mcp-server-versions", namespaceId, null, null, "nacos", null);
        }
    }

    private void injectToolAndEndpoint(String namespaceId, String mcpServerId, McpServerStorageInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        serverSpecification.setCapabilities(new LinkedList());
        if (null != toolSpecification && null != toolSpecification.getTools() && !toolSpecification.getTools().isEmpty()) {
            this.toolOperationService.refreshMcpTool(namespaceId, serverSpecification, toolSpecification);
            serverSpecification.getCapabilities().add(McpCapability.TOOL);
            String version = serverSpecification.getVersionDetail().getVersion();
            String toolSpecDataId = McpConfigUtils.formatServerToolSpecDataId(mcpServerId, version);
            serverSpecification.setToolsDescriptionRef(toolSpecDataId);
        }
        if (null != endpointSpecification) {
            Service service = this.endpointOperationService.createMcpServerEndpointServiceIfNecessary(namespaceId, serverSpecification.getName(), endpointSpecification);
            McpServiceRef serviceRef = new McpServiceRef();
            serviceRef.setNamespaceId(service.getNamespace());
            serviceRef.setGroupName(service.getGroup());
            serviceRef.setServiceName(service.getName());
            serverSpecification.getRemoteServerConfig().setServiceRef(serviceRef);
        }
    }

    private ConfigFormV3 buildMcpServerVersionForm(String namespaceId, McpServerVersionInfo mcpServerVersionInfo) {
        ConfigFormV3 configFormV3 = new ConfigFormV3();
        configFormV3.setGroupName("mcp-server-versions");
        configFormV3.setGroup("mcp-server-versions");
        configFormV3.setNamespaceId(namespaceId);
        configFormV3.setDataId(McpConfigUtils.formatServerVersionInfoDataId(mcpServerVersionInfo.getId()));
        configFormV3.setContent(JacksonUtils.toJson((Object)mcpServerVersionInfo));
        configFormV3.setType(ConfigType.JSON.getType());
        configFormV3.setAppName(mcpServerVersionInfo.getName());
        configFormV3.setSrcUser("nacos");
        String configTags = McpConfigUtils.buildMcpServerVersionConfigTags(mcpServerVersionInfo.getName());
        configFormV3.setConfigTags(configTags);
        return configFormV3;
    }

    private ConfigFormV3 buildMcpConfigForm(String namespaceId, String mcpServerId, String version, McpServerBasicInfo serverSpecification) {
        ConfigFormV3 configFormV3 = new ConfigFormV3();
        configFormV3.setGroupName("mcp-server");
        configFormV3.setGroup("mcp-server");
        configFormV3.setNamespaceId(namespaceId);
        configFormV3.setDataId(McpConfigUtils.formatServerSpecInfoDataId(mcpServerId, version));
        configFormV3.setContent(JacksonUtils.toJson((Object)serverSpecification));
        configFormV3.setType(ConfigType.JSON.getType());
        configFormV3.setAppName(serverSpecification.getName());
        configFormV3.setSrcUser("nacos");
        configFormV3.setConfigTags("nacos.internal.config=mcp");
        return configFormV3;
    }

    private ConfigQueryChainRequest buildQueryMcpServerRequest(String namespaceId, String mcpServerId, String version) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setDataId(McpConfigUtils.formatServerSpecInfoDataId(mcpServerId, version));
        request.setGroup("mcp-server");
        request.setTenant(namespaceId);
        return request;
    }

    private ConfigQueryChainRequest buildQueryMcpServerVersionInfoRequest(String namespaceId, String mcpServerId) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setDataId(McpConfigUtils.formatServerVersionInfoDataId(mcpServerId));
        request.setGroup("mcp-server-versions");
        request.setTenant(namespaceId);
        return request;
    }

    private McpServerVersionInfo transferToMcpServerVersionInfo(String content) {
        McpServerVersionInfo versionInfo = (McpServerVersionInfo)JacksonUtils.toObj((String)content, McpServerVersionInfo.class);
        String latestPublishedVersion = versionInfo.getLatestPublishedVersion();
        for (ServerVersionDetail versionDetail : versionInfo.getVersionDetails()) {
            if (versionDetail.getVersion().equals(latestPublishedVersion)) {
                versionDetail.setIs_latest(Boolean.valueOf(true));
                versionInfo.setVersionDetail(versionDetail);
                break;
            }
            versionDetail.setIs_latest(Boolean.valueOf(false));
        }
        versionInfo.setVersion(latestPublishedVersion);
        return versionInfo;
    }

    private String resolveMcpServerId(String namespaceId, String serverName, String serverId) {
        if (StringUtils.isNotEmpty((String)serverId)) {
            return serverId;
        }
        McpServerIndexData indexData = this.mcpServerIndex.getMcpServerByName(namespaceId, serverName);
        if (Objects.nonNull(indexData)) {
            return indexData.getId();
        }
        return null;
    }
}

