/*
 * Decompiled with CFR 0.152.
 */
package io.agora.media;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.TreeMap;

public class ByteBuf {
    ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);

    public ByteBuf() {
    }

    public ByteBuf(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte[] asBytes() {
        byte[] out = new byte[this.buffer.position()];
        this.buffer.rewind();
        this.buffer.get(out, 0, out.length);
        return out;
    }

    public ByteBuf put(short v) {
        this.buffer.putShort(v);
        return this;
    }

    public ByteBuf put(byte[] v) {
        this.put((short)v.length);
        this.buffer.put(v);
        return this;
    }

    public ByteBuf put(int v) {
        this.buffer.putInt(v);
        return this;
    }

    public ByteBuf put(long v) {
        this.buffer.putLong(v);
        return this;
    }

    public ByteBuf put(String v) {
        return this.put(v.getBytes());
    }

    public ByteBuf put(TreeMap<Short, String> extra) {
        this.put((short)extra.size());
        for (Map.Entry<Short, String> pair : extra.entrySet()) {
            this.put(pair.getKey());
            this.put(pair.getValue());
        }
        return this;
    }

    public ByteBuf putIntMap(TreeMap<Short, Integer> extra) {
        this.put((short)extra.size());
        for (Map.Entry<Short, Integer> pair : extra.entrySet()) {
            this.put(pair.getKey());
            this.put(pair.getValue());
        }
        return this;
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public byte[] readBytes() {
        short length = this.readShort();
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    public String readString() {
        byte[] bytes = this.readBytes();
        return new String(bytes);
    }

    public TreeMap readMap() {
        TreeMap<Short, String> map = new TreeMap<Short, String>();
        short length = this.readShort();
        for (short i = 0; i < length; i = (short)(i + 1)) {
            short k = this.readShort();
            String v = this.readString();
            map.put(k, v);
        }
        return map;
    }

    public TreeMap<Short, Integer> readIntMap() {
        TreeMap<Short, Integer> map = new TreeMap<Short, Integer>();
        short length = this.readShort();
        for (short i = 0; i < length; i = (short)(i + 1)) {
            short k = this.readShort();
            Integer v = this.readInt();
            map.put(k, v);
        }
        return map;
    }
}

