/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.baomidou.dynamic.datasource.AbstractRoutingDataSource;
import com.baomidou.dynamic.datasource.DynamicGroupDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.p6spy.engine.spy.P6DataSource;
import io.seata.rm.datasource.DataSourceProxy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private static final String UNDERLINE = "_";
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private final Map<String, DynamicGroupDataSource> groupDataSources = new ConcurrentHashMap<String, DynamicGroupDataSource>();
    private DynamicDataSourceProvider provider;
    private String primary;
    private boolean strict;
    private Class<? extends DynamicDataSourceStrategy> strategy;
    private boolean p6spy;
    private boolean seata;

    @Override
    public DataSource determineDataSource() {
        return this.getDataSource(DynamicDataSourceContextHolder.peek());
    }

    private DataSource determinePrimaryDataSource() {
        log.debug("dynamic-datasource switch to the primary datasource");
        return this.groupDataSources.containsKey(this.primary) ? this.groupDataSources.get(this.primary).determineDataSource() : this.dataSourceMap.get(this.primary);
    }

    public Map<String, DataSource> getCurrentDataSources() {
        return this.dataSourceMap;
    }

    public Map<String, DynamicGroupDataSource> getCurrentGroupDataSources() {
        return this.groupDataSources;
    }

    public DataSource getDataSource(String ds) {
        if (StringUtils.isEmpty((Object)ds)) {
            return this.determinePrimaryDataSource();
        }
        if (!this.groupDataSources.isEmpty() && this.groupDataSources.containsKey(ds)) {
            log.debug("dynamic-datasource switch to the datasource named [{}]", (Object)ds);
            return this.groupDataSources.get(ds).determineDataSource();
        }
        if (this.dataSourceMap.containsKey(ds)) {
            log.debug("dynamic-datasource switch to the datasource named [{}]", (Object)ds);
            return this.dataSourceMap.get(ds);
        }
        if (this.strict) {
            throw new RuntimeException("dynamic-datasource could not find a datasource named" + ds);
        }
        return this.determinePrimaryDataSource();
    }

    public synchronized void addDataSource(String ds, DataSource dataSource) {
        if (!this.dataSourceMap.containsKey(ds)) {
            dataSource = this.wrapDataSource(ds, dataSource);
            this.dataSourceMap.put(ds, dataSource);
            this.addGroupDataSource(ds, dataSource);
            log.info("dynamic-datasource - load a datasource named [{}] success", (Object)ds);
        } else {
            log.warn("dynamic-datasource - load a datasource named [{}] failed, because it already exist", (Object)ds);
        }
    }

    private DataSource wrapDataSource(String ds, DataSource dataSource) {
        if (this.p6spy) {
            dataSource = new P6DataSource(dataSource);
            log.debug("dynamic-datasource [{}] wrap p6spy plugin", (Object)ds);
        }
        if (this.seata) {
            dataSource = new DataSourceProxy(dataSource);
            log.debug("dynamic-datasource [{}] wrap seata plugin", (Object)ds);
        }
        return dataSource;
    }

    private void addGroupDataSource(String ds, DataSource dataSource) {
        if (ds.contains(UNDERLINE)) {
            String group = ds.split(UNDERLINE)[0];
            if (this.groupDataSources.containsKey(group)) {
                this.groupDataSources.get(group).addDatasource(dataSource);
            } else {
                try {
                    DynamicGroupDataSource groupDatasource = new DynamicGroupDataSource(group, this.strategy.newInstance());
                    groupDatasource.addDatasource(dataSource);
                    this.groupDataSources.put(group, groupDatasource);
                }
                catch (Exception e) {
                    log.error("dynamic-datasource - add the datasource named [{}] error", (Object)ds, (Object)e);
                    this.dataSourceMap.remove(ds);
                }
            }
        }
    }

    public synchronized void removeDataSource(String ds) {
        if (!StringUtils.hasText((String)ds)) {
            throw new RuntimeException("remove parameter could not be empty");
        }
        if (this.primary.equals(ds)) {
            throw new RuntimeException("could not remove primary datasource");
        }
        if (this.dataSourceMap.containsKey(ds)) {
            String group;
            DataSource dataSource = this.dataSourceMap.get(ds);
            try {
                this.closeDataSource(ds, dataSource);
            }
            catch (Exception e) {
                throw new RuntimeException("dynamic-datasource - remove the database named " + ds + " failed", e);
            }
            this.dataSourceMap.remove(ds);
            if (ds.contains(UNDERLINE) && this.groupDataSources.containsKey(group = ds.split(UNDERLINE)[0])) {
                this.groupDataSources.get(group).removeDatasource(dataSource);
            }
            log.info("dynamic-datasource - remove the database named [{}] success", (Object)ds);
        } else {
            log.warn("dynamic-datasource - could not find a database named [{}]", (Object)ds);
        }
    }

    public void setP6spy(boolean p6spy) {
        if (p6spy) {
            try {
                Class.forName("com.p6spy.engine.spy.P6DataSource");
                log.info("dynamic-datasource detect P6SPY plugin and enabled it");
                this.p6spy = true;
            }
            catch (Exception e) {
                log.warn("dynamic-datasource enabled P6SPY ,however without p6spy dependency");
            }
        } else {
            this.p6spy = false;
        }
    }

    public void setSeata(boolean seata) {
        if (seata) {
            try {
                Class.forName("io.seata.rm.datasource.DataSourceProxy");
                this.seata = true;
                log.info("dynamic-datasource detect ALIBABA SEATA and enabled it");
            }
            catch (Exception e) {
                this.seata = false;
                log.warn("dynamic-datasource enabled ALIBABA SEATA  ,however without seata dependency");
            }
        }
    }

    public void destroy() throws Exception {
        log.info("dynamic-datasource start closing ....");
        for (Map.Entry<String, DataSource> item : this.dataSourceMap.entrySet()) {
            this.closeDataSource(item.getKey(), item.getValue());
        }
        log.info("dynamic-datasource all closed success,bye");
    }

    private void closeDataSource(String name, DataSource dataSource) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (this.seata) {
            DataSourceProxy dataSourceProxy = (DataSourceProxy)dataSource;
            dataSource = dataSourceProxy.getTargetDataSource();
        }
        if (this.p6spy) {
            Field realDataSourceField = P6DataSource.class.getDeclaredField("realDataSource");
            realDataSourceField.setAccessible(true);
            dataSource = (DataSource)realDataSourceField.get(dataSource);
        }
        Class<?> clazz = dataSource.getClass();
        try {
            Method closeMethod = clazz.getDeclaredMethod("close", new Class[0]);
            closeMethod.invoke((Object)dataSource, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.warn("dynamic-datasource close the datasource named [{}] failed,", (Object)name);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, DataSource> dataSources = this.provider.loadDataSources();
        for (Map.Entry<String, DataSource> dsItem : dataSources.entrySet()) {
            this.addDataSource(dsItem.getKey(), dsItem.getValue());
        }
        if (this.groupDataSources.containsKey(this.primary)) {
            log.info("dynamic-datasource initial loaded [{}] datasource,primary group datasource named [{}]", (Object)dataSources.size(), (Object)this.primary);
        } else if (this.dataSourceMap.containsKey(this.primary)) {
            log.info("dynamic-datasource initial loaded [{}] datasource,primary datasource named [{}]", (Object)dataSources.size(), (Object)this.primary);
        } else {
            throw new RuntimeException("dynamic-datasource Please check the setting of primary");
        }
    }

    public void setProvider(DynamicDataSourceProvider provider) {
        this.provider = provider;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setStrategy(Class<? extends DynamicDataSourceStrategy> strategy) {
        this.strategy = strategy;
    }
}

